/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.common;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.common.schematree.IMeasurementSchemaInfo;
import org.apache.iotdb.db.queryengine.execution.operator.schema.source.TimeSeriesSchemaSource;
import org.apache.iotdb.db.schemaengine.schemaregion.utils.MetaUtils;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class TimeseriesContext {
    private final String dataType;
    private final String encoding;
    private final String compression;
    private final String tags;
    private final String alias;
    private final String attributes;
    private final String deadband;
    private final String deadbandParameters;

    public TimeseriesContext(IMeasurementSchemaInfo schemaInfo) {
        this.dataType = schemaInfo.getSchema().getType().toString();
        this.encoding = schemaInfo.getSchema().getEncodingType().toString();
        this.compression = schemaInfo.getSchema().getCompressor().toString();
        this.alias = schemaInfo.getAlias();
        this.tags = TimeSeriesSchemaSource.mapToString(schemaInfo.getTagMap());
        this.attributes = TimeSeriesSchemaSource.mapToString(schemaInfo.getAttributeMap());
        Pair<String, String> deadbandInfo = MetaUtils.parseDeadbandInfo(schemaInfo.getSchema().getProps());
        this.deadband = (String)deadbandInfo.left;
        this.deadbandParameters = (String)deadbandInfo.right;
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getCompression() {
        return this.compression;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getTags() {
        return this.tags;
    }

    public String getAttributes() {
        return this.attributes;
    }

    public String getDeadbandParameters() {
        return this.deadbandParameters;
    }

    public String getDeadband() {
        return this.deadband;
    }

    public TimeseriesContext(String dataType, String alias, String encoding, String compression, String tags, String attributes, String deadband, String deadbandParameters) {
        this.dataType = dataType;
        this.alias = alias;
        this.encoding = encoding;
        this.compression = compression;
        this.tags = tags;
        this.attributes = attributes;
        this.deadband = deadband;
        this.deadbandParameters = deadbandParameters;
    }

    public void serializeAttributes(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((String)this.dataType, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((String)this.alias, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((String)this.encoding, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((String)this.compression, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((String)this.tags, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((String)this.attributes, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((String)this.deadband, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((String)this.deadbandParameters, (ByteBuffer)byteBuffer);
    }

    public void serializeAttributes(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((String)this.dataType, (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.alias, (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.encoding, (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.compression, (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.tags, (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.attributes, (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.deadband, (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.deadbandParameters, (OutputStream)stream);
    }

    public static TimeseriesContext deserialize(ByteBuffer buffer) {
        String dataType = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        String alias = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        String encoding = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        String compression = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        String tags = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        String attributes = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        String deadband = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        String deadbandParameters = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        return new TimeseriesContext(dataType, alias, encoding, compression, tags, attributes, deadband, deadbandParameters);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TimeseriesContext that = (TimeseriesContext)obj;
        boolean res = Objects.equals(this.dataType, that.dataType) && Objects.equals(this.alias, that.alias) && this.encoding.equals(that.encoding) && Objects.equals(this.compression, that.compression) && Objects.equals(this.tags, that.tags) && Objects.equals(this.attributes, that.attributes) && Objects.equals(this.deadband, that.deadband) && Objects.equals(this.deadbandParameters, that.deadbandParameters);
        return res;
    }

    public int hashCode() {
        return Objects.hash(this.dataType, this.alias, this.encoding, this.compression, this.tags, this.attributes, this.deadband, this.deadbandParameters);
    }
}

