/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write.partition;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.commons.utils.ThriftCommonsSerDeUtils;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;

public class AddRegionLocationPlan
extends ConfigPhysicalPlan {
    TConsensusGroupId regionId;
    TDataNodeLocation newLocation;

    public AddRegionLocationPlan() {
        super(ConfigPhysicalPlanType.AddRegionLocation);
    }

    public AddRegionLocationPlan(TConsensusGroupId regionId, TDataNodeLocation newLocation) {
        this();
        this.regionId = regionId;
        this.newLocation = newLocation;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getType().getPlanType());
        ThriftCommonsSerDeUtils.serializeTConsensusGroupId((TConsensusGroupId)this.regionId, (DataOutputStream)stream);
        ThriftCommonsSerDeUtils.serializeTDataNodeLocation((TDataNodeLocation)this.newLocation, (DataOutputStream)stream);
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        this.regionId = ThriftCommonsSerDeUtils.deserializeTConsensusGroupId((ByteBuffer)buffer);
        this.newLocation = ThriftCommonsSerDeUtils.deserializeTDataNodeLocation((ByteBuffer)buffer);
    }

    public TConsensusGroupId getRegionId() {
        return this.regionId;
    }

    public TDataNodeLocation getNewLocation() {
        return this.newLocation;
    }
}

