/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.DataNodeDevicePathCache;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.ArrayDeviceTimeIndex;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.ITimeIndex;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class PlainDeviceTimeIndex
extends ArrayDeviceTimeIndex
implements ITimeIndex {
    @Override
    public void serialize(OutputStream outputStream) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public PlainDeviceTimeIndex deserialize(InputStream inputStream) throws IOException {
        int i;
        int deviceNum = ReadWriteIOUtils.readInt((InputStream)inputStream);
        this.startTimes = new long[deviceNum];
        this.endTimes = new long[deviceNum];
        for (i = 0; i < deviceNum; ++i) {
            this.startTimes[i] = ReadWriteIOUtils.readLong((InputStream)inputStream);
            this.endTimes[i] = ReadWriteIOUtils.readLong((InputStream)inputStream);
            this.minStartTime = Math.min(this.minStartTime, this.startTimes[i]);
            this.maxEndTime = Math.max(this.maxEndTime, this.endTimes[i]);
        }
        for (i = 0; i < deviceNum; ++i) {
            String path = ReadWriteIOUtils.readString((InputStream)inputStream);
            int index = ReadWriteIOUtils.readInt((InputStream)inputStream);
            try {
                PartialPath partialPath = DataNodeDevicePathCache.getInstance().getPartialPath(path);
                this.deviceToIndex.put(partialPath.getIDeviceID(), index);
                continue;
            }
            catch (IllegalPathException e) {
                this.deviceToIndex.put(IDeviceID.Factory.DEFAULT_FACTORY.create(path), index);
            }
        }
        return this;
    }

    @Override
    public PlainDeviceTimeIndex deserialize(ByteBuffer buffer) {
        int i;
        int deviceNum = buffer.getInt();
        this.startTimes = new long[deviceNum];
        this.endTimes = new long[deviceNum];
        for (i = 0; i < deviceNum; ++i) {
            this.startTimes[i] = buffer.getLong();
            this.endTimes[i] = buffer.getLong();
            this.minStartTime = Math.min(this.minStartTime, this.startTimes[i]);
            this.maxEndTime = Math.max(this.maxEndTime, this.endTimes[i]);
        }
        for (i = 0; i < deviceNum; ++i) {
            String path = ReadWriteIOUtils.readString((ByteBuffer)buffer);
            int index = buffer.getInt();
            try {
                PartialPath partialPath = DataNodeDevicePathCache.getInstance().getPartialPath(path);
                this.deviceToIndex.put(partialPath.getIDeviceID(), index);
                continue;
            }
            catch (IllegalPathException e) {
                this.deviceToIndex.put(IDeviceID.Factory.DEFAULT_FACTORY.create(path), index);
            }
        }
        return this;
    }

    public static Set<IDeviceID> getDevices(InputStream inputStream) throws IOException {
        int deviceNum = ReadWriteIOUtils.readInt((InputStream)inputStream);
        ReadWriteIOUtils.skip((InputStream)inputStream, (long)(2L * (long)deviceNum * 8L));
        HashSet<IDeviceID> devices = new HashSet<IDeviceID>();
        for (int i = 0; i < deviceNum; ++i) {
            String path = DataNodeDevicePathCache.getInstance().getDeviceId(ReadWriteIOUtils.readString((InputStream)inputStream));
            ReadWriteIOUtils.skip((InputStream)inputStream, (long)4L);
            devices.add(IDeviceID.Factory.DEFAULT_FACTORY.create(path));
        }
        return devices;
    }

    @Override
    public byte getTimeIndexType() {
        return 1;
    }
}

