/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.node;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.SingleChildProcessNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;

public class FilterNode
extends SingleChildProcessNode {
    private Expression predicate;

    public FilterNode(PlanNodeId id, PlanNode child, Expression predicate) {
        super(id, child);
        this.predicate = predicate;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitFilter(this, context);
    }

    @Override
    public PlanNode clone() {
        return new FilterNode(this.id, null, this.predicate);
    }

    @Override
    public List<String> getOutputColumnNames() {
        return null;
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.TABLE_FILTER_NODE.serialize(byteBuffer);
        Expression.serialize(this.predicate, byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.TABLE_FILTER_NODE.serialize(stream);
        Expression.serialize(this.predicate, stream);
    }

    public static FilterNode deserialize(ByteBuffer byteBuffer) {
        Expression predicate = Expression.deserialize(byteBuffer);
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new FilterNode(planNodeId, null, predicate);
    }

    public Expression getPredicate() {
        return this.predicate;
    }

    public void setPredicate(Expression predicate) {
        this.predicate = predicate;
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return this.child.getOutputSymbols();
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new FilterNode(this.id, (PlanNode)Iterables.getOnlyElement(newChildren), this.predicate);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FilterNode filterNode = (FilterNode)o;
        return Objects.equal((Object)this.predicate, (Object)filterNode.predicate);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.predicate});
    }

    public String toString() {
        return "FilterNode-" + this.getPlanNodeId();
    }
}

