/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.source;

import com.google.common.collect.ImmutableList;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.path.AlignedPath;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathType;
import org.apache.iotdb.commons.schema.column.ColumnHeader;
import org.apache.iotdb.commons.schema.column.ColumnHeaderConstant;
import org.apache.iotdb.commons.utils.TestOnly;
import org.apache.iotdb.db.queryengine.common.TimeseriesContext;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.RegionScanNode;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.apache.tsfile.write.schema.MeasurementSchema;

public class TimeseriesRegionScanNode
extends RegionScanNode {
    private Map<PartialPath, Map<PartialPath, List<TimeseriesContext>>> deviceToTimeseriesSchemaInfo;

    public TimeseriesRegionScanNode(PlanNodeId planNodeId, boolean outputCount, TRegionReplicaSet regionReplicaSet) {
        super(planNodeId);
        this.regionReplicaSet = regionReplicaSet;
        this.outputCount = outputCount;
    }

    public TimeseriesRegionScanNode(PlanNodeId planNodeId, Map<PartialPath, Map<PartialPath, List<TimeseriesContext>>> deviceToTimeseriesSchemaInfo, boolean outputCount, TRegionReplicaSet regionReplicaSet) {
        super(planNodeId);
        this.deviceToTimeseriesSchemaInfo = deviceToTimeseriesSchemaInfo;
        this.regionReplicaSet = regionReplicaSet;
        this.outputCount = outputCount;
    }

    public void setDeviceToTimeseriesSchemaInfo(Map<PartialPath, Map<PartialPath, List<TimeseriesContext>>> deviceToTimeseriesSchemaInfo) {
        this.deviceToTimeseriesSchemaInfo = deviceToTimeseriesSchemaInfo;
    }

    public Map<PartialPath, Map<PartialPath, List<TimeseriesContext>>> getDeviceToTimeseriesSchemaInfo() {
        return this.deviceToTimeseriesSchemaInfo;
    }

    @Override
    public List<PlanNode> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public void addChild(PlanNode child) {
        throw new UnsupportedOperationException("TimeseriesRegionScanNode does not support addChild");
    }

    @Override
    public PlanNode clone() {
        return new TimeseriesRegionScanNode(this.getPlanNodeId(), this.getDeviceToTimeseriesSchemaInfo(), this.isOutputCount(), this.getRegionReplicaSet());
    }

    @Override
    public List<String> getOutputColumnNames() {
        return this.outputCount ? ColumnHeaderConstant.countTimeSeriesColumnHeaders.stream().map(ColumnHeader::getColumnName).collect(Collectors.toList()) : ColumnHeaderConstant.showTimeSeriesColumnHeaders.stream().map(ColumnHeader::getColumnName).collect(Collectors.toList());
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitTimeSeriesRegionScan(this, context);
    }

    @Override
    public int allowedChildCount() {
        return 0;
    }

    public static PlanNode deserialize(ByteBuffer buffer) {
        int size = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        HashMap<PartialPath, Map<PartialPath, List<TimeseriesContext>>> deviceToTimeseriesSchemaInfo = new HashMap<PartialPath, Map<PartialPath, List<TimeseriesContext>>>();
        for (int i = 0; i < size; ++i) {
            int nodeSize = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
            String[] nodes = new String[nodeSize];
            for (int j = 0; j < nodeSize; ++j) {
                nodes[j] = ReadWriteIOUtils.readString((ByteBuffer)buffer);
            }
            PartialPath devicePath = new PartialPath(nodes);
            int pathSize = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
            HashMap measurementToSchemaInfo = new HashMap();
            for (int j = 0; j < pathSize; ++j) {
                PartialPath path = TimeseriesRegionScanNode.deserializePartialPath(nodes, buffer);
                int schemaSize = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
                ArrayList<TimeseriesContext> schemaInfos = new ArrayList<TimeseriesContext>();
                for (int k = 0; k < schemaSize; ++k) {
                    schemaInfos.add(TimeseriesContext.deserialize(buffer));
                }
                measurementToSchemaInfo.put(path, schemaInfos);
            }
            deviceToTimeseriesSchemaInfo.put(devicePath, measurementToSchemaInfo);
        }
        boolean outputCount = ReadWriteIOUtils.readBool((ByteBuffer)buffer);
        return new TimeseriesRegionScanNode(PlanNodeId.deserialize(buffer), deviceToTimeseriesSchemaInfo, outputCount, null);
    }

    @TestOnly
    public List<PartialPath> getMeasurementPath() {
        return this.deviceToTimeseriesSchemaInfo.values().stream().map(Map::keySet).flatMap(Collection::stream).flatMap(path -> {
            if (path instanceof AlignedPath) {
                AlignedPath alignedPath = (AlignedPath)path;
                return alignedPath.getMeasurementList().stream().map(measurementName -> alignedPath.getDevicePath().concatAsMeasurementPath(measurementName));
            }
            return Stream.of(path);
        }).collect(Collectors.toList());
    }

    public String toString() {
        return String.format("%s[%s]", this.getClass().getSimpleName(), this.deviceToTimeseriesSchemaInfo.entrySet().stream().map(entry -> String.format("%s -> %s", ((PartialPath)entry.getKey()).getFullPath(), ((Map)entry.getValue()).entrySet().stream().map(entry1 -> String.format("%s -> %s", ((PartialPath)entry1.getKey()).getFullPath(), ((List)entry1.getValue()).stream().map(Object::toString).collect(Collectors.joining(", ")))).collect(Collectors.joining(", ")))).collect(Collectors.joining(", ")));
    }

    @Override
    public Set<PartialPath> getDevicePaths() {
        return new HashSet<PartialPath>(this.deviceToTimeseriesSchemaInfo.keySet());
    }

    @Override
    public void addDevicePath(PartialPath devicePath, RegionScanNode node) {
        this.deviceToTimeseriesSchemaInfo.put(devicePath, ((TimeseriesRegionScanNode)node).getDeviceToTimeseriesSchemaInfo().get(devicePath));
    }

    @Override
    public void clearPath() {
        this.deviceToTimeseriesSchemaInfo = new HashMap<PartialPath, Map<PartialPath, List<TimeseriesContext>>>();
    }

    @Override
    public long getSize() {
        return this.deviceToTimeseriesSchemaInfo.values().stream().mapToLong(Map::size).sum();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TimeseriesRegionScanNode)) {
            return false;
        }
        TimeseriesRegionScanNode that = (TimeseriesRegionScanNode)o;
        return this.deviceToTimeseriesSchemaInfo.equals(that.deviceToTimeseriesSchemaInfo) && this.outputCount == that.isOutputCount();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.deviceToTimeseriesSchemaInfo, this.outputCount);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.TIMESERIES_REGION_SCAN.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.deviceToTimeseriesSchemaInfo.size(), (ByteBuffer)byteBuffer);
        for (Map.Entry<PartialPath, Map<PartialPath, List<TimeseriesContext>>> entry : this.deviceToTimeseriesSchemaInfo.entrySet()) {
            int size = entry.getKey().getNodeLength();
            ReadWriteIOUtils.write((int)size, (ByteBuffer)byteBuffer);
            String[] nodes = entry.getKey().getNodes();
            for (int i = 0; i < size; ++i) {
                ReadWriteIOUtils.write((String)nodes[i], (ByteBuffer)byteBuffer);
            }
            ReadWriteIOUtils.write((int)entry.getValue().size(), (ByteBuffer)byteBuffer);
            for (Map.Entry<PartialPath, List<TimeseriesContext>> timseriesEntry : entry.getValue().entrySet()) {
                this.serializeMeasurements(timseriesEntry.getKey(), byteBuffer);
                ReadWriteIOUtils.write((int)timseriesEntry.getValue().size(), (ByteBuffer)byteBuffer);
                for (TimeseriesContext timeseriesContext : timseriesEntry.getValue()) {
                    timeseriesContext.serializeAttributes(byteBuffer);
                }
            }
        }
        ReadWriteIOUtils.write((Boolean)this.outputCount, (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.TIMESERIES_REGION_SCAN.serialize(stream);
        ReadWriteIOUtils.write((int)this.deviceToTimeseriesSchemaInfo.size(), (OutputStream)stream);
        for (Map.Entry<PartialPath, Map<PartialPath, List<TimeseriesContext>>> entry : this.deviceToTimeseriesSchemaInfo.entrySet()) {
            int size = entry.getKey().getNodeLength();
            ReadWriteIOUtils.write((int)size, (OutputStream)stream);
            String[] nodes = entry.getKey().getNodes();
            for (int i = 0; i < size; ++i) {
                ReadWriteIOUtils.write((String)nodes[i], (OutputStream)stream);
            }
            ReadWriteIOUtils.write((int)entry.getValue().size(), (OutputStream)stream);
            for (Map.Entry<PartialPath, List<TimeseriesContext>> timseriesEntry : entry.getValue().entrySet()) {
                this.serializeMeasurements(timseriesEntry.getKey(), stream);
                ReadWriteIOUtils.write((int)timseriesEntry.getValue().size(), (OutputStream)stream);
                for (TimeseriesContext timeseriesContext : timseriesEntry.getValue()) {
                    timeseriesContext.serializeAttributes(stream);
                }
            }
        }
        ReadWriteIOUtils.write((Boolean)this.outputCount, (OutputStream)stream);
    }

    private static PartialPath deserializePartialPath(String[] deviceNodes, ByteBuffer buffer) {
        int i;
        byte pathType = buffer.get();
        if (pathType == 0) {
            String[] newNodes = Arrays.copyOf(deviceNodes, deviceNodes.length + 1);
            newNodes[deviceNodes.length] = ReadWriteIOUtils.readString((ByteBuffer)buffer);
            return new MeasurementPath(newNodes);
        }
        int size = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        ArrayList<String> measurements = new ArrayList<String>();
        ArrayList<MeasurementSchema> schemaList = new ArrayList<MeasurementSchema>();
        for (i = 0; i < size; ++i) {
            measurements.add(ReadWriteIOUtils.readString((ByteBuffer)buffer));
        }
        size = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        for (i = 0; i < size; ++i) {
            schemaList.add(MeasurementSchema.deserializeFrom((ByteBuffer)buffer));
        }
        return new AlignedPath(deviceNodes, measurements, schemaList);
    }

    private void serializeMeasurements(PartialPath path, DataOutputStream stream) throws IOException {
        if (path instanceof MeasurementPath) {
            PathType.Measurement.serialize((OutputStream)stream);
            ReadWriteIOUtils.write((String)path.getMeasurement(), (OutputStream)stream);
        } else if (path instanceof AlignedPath) {
            int i;
            PathType.Aligned.serialize((OutputStream)stream);
            AlignedPath alignedPath = (AlignedPath)path;
            List measurements = alignedPath.getMeasurementList();
            List schemaList = alignedPath.getSchemaList();
            ReadWriteIOUtils.write((int)measurements.size(), (OutputStream)stream);
            for (i = 0; i < measurements.size(); ++i) {
                ReadWriteIOUtils.write((String)((String)measurements.get(i)), (OutputStream)stream);
            }
            ReadWriteIOUtils.write((int)schemaList.size(), (OutputStream)stream);
            for (i = 0; i < schemaList.size(); ++i) {
                ((IMeasurementSchema)schemaList.get(i)).serializeTo((OutputStream)stream);
            }
        }
    }

    private void serializeMeasurements(PartialPath path, ByteBuffer buffer) {
        if (path instanceof MeasurementPath) {
            PathType.Measurement.serialize(buffer);
            ReadWriteIOUtils.write((String)path.getMeasurement(), (ByteBuffer)buffer);
        } else if (path instanceof AlignedPath) {
            int i;
            PathType.Aligned.serialize(buffer);
            AlignedPath alignedPath = (AlignedPath)path;
            List measurements = alignedPath.getMeasurementList();
            List schemaList = alignedPath.getSchemaList();
            ReadWriteIOUtils.write((int)measurements.size(), (ByteBuffer)buffer);
            for (i = 0; i < measurements.size(); ++i) {
                ReadWriteIOUtils.write((String)((String)measurements.get(i)), (ByteBuffer)buffer);
            }
            ReadWriteIOUtils.write((int)schemaList.size(), (ByteBuffer)buffer);
            for (i = 0; i < schemaList.size(); ++i) {
                ((IMeasurementSchema)schemaList.get(i)).serializeTo(buffer);
            }
        }
    }
}

