/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.block.procedure.primitive;

import org.eclipse.collections.api.block.predicate.primitive.CharPredicate;
import org.eclipse.collections.api.block.procedure.primitive.CharProcedure;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.tuple.Tuples;

public class CharCaseProcedure
implements CharProcedure {
    private static final long serialVersionUID = 1L;
    private final MutableList<Pair<CharPredicate, CharProcedure>> predicateProcedures = Lists.mutable.empty();
    private CharProcedure defaultProcedure;

    public CharCaseProcedure() {
    }

    public CharCaseProcedure(CharProcedure newDefaultProcedure) {
        this.setDefault(newDefaultProcedure);
    }

    public CharCaseProcedure addCase(CharPredicate predicate, CharProcedure procedure) {
        this.predicateProcedures.add(Tuples.pair(predicate, procedure));
        return this;
    }

    public CharCaseProcedure setDefault(CharProcedure procedure) {
        this.defaultProcedure = procedure;
        return this;
    }

    @Override
    public void value(char argument) {
        int localSize = this.predicateProcedures.size();
        for (int i = 0; i < localSize; ++i) {
            Pair pair = (Pair)this.predicateProcedures.get(i);
            if (!((CharPredicate)pair.getOne()).accept(argument)) continue;
            ((CharProcedure)pair.getTwo()).value(argument);
            return;
        }
        if (this.defaultProcedure != null) {
            this.defaultProcedure.value(argument);
        }
    }

    public String toString() {
        return "new CharCaseProcedure(" + this.predicateProcedures + ')';
    }
}

