/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column;

import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnCache;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.read.common.type.Type;
import org.apache.tsfile.read.common.type.TypeEnum;

public abstract class ColumnTransformer {
    protected final Type returnType;
    protected final ColumnCache columnCache;
    protected int referenceCount;

    protected ColumnTransformer(Type returnType) {
        this.returnType = returnType;
        this.columnCache = new ColumnCache();
        this.referenceCount = 0;
    }

    public void tryEvaluate() {
        if (!this.columnCache.hasCached()) {
            this.evaluate();
        }
    }

    public Column getColumn() {
        return this.columnCache.getColumn();
    }

    public void addReferenceCount() {
        ++this.referenceCount;
    }

    public void initializeColumnCache(Column column) {
        this.columnCache.cacheColumn(column, this.referenceCount);
    }

    public int getColumnCachePositionCount() {
        return this.columnCache.getPositionCount();
    }

    public Type getType() {
        return this.returnType;
    }

    public boolean isReturnTypeNumeric() {
        if (this.returnType == null) {
            return true;
        }
        TypeEnum typeEnum = this.returnType.getTypeEnum();
        return typeEnum.equals((Object)TypeEnum.INT32) || typeEnum.equals((Object)TypeEnum.INT64) || typeEnum.equals((Object)TypeEnum.FLOAT) || typeEnum.equals((Object)TypeEnum.DOUBLE);
    }

    public static boolean typeEquals(ColumnTransformer a, ColumnTransformer b) {
        if (a.getType() == null || b.getType() == null) {
            return true;
        }
        return a.getType().getTypeEnum().equals((Object)b.getType().getTypeEnum());
    }

    public boolean typeEquals(TypeEnum typeEnum) {
        return this.returnType == null || this.returnType.getTypeEnum().equals((Object)typeEnum);
    }

    public boolean typeNotEquals(TypeEnum typeEnum) {
        return this.returnType == null || !this.returnType.getTypeEnum().equals((Object)typeEnum);
    }

    protected abstract void evaluate();

    protected abstract void checkType();

    public void close() {
    }
}

