/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.parameter;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.statement.component.FillPolicy;
import org.apache.iotdb.db.queryengine.plan.statement.literal.Literal;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.apache.tsfile.utils.TimeDuration;

public class FillDescriptor {
    private final FillPolicy fillPolicy;
    private final Literal fillValue;
    private final TimeDuration timeDurationThreshold;

    public FillDescriptor(FillPolicy fillPolicy, Literal fillValue, TimeDuration timeDurationThreshold) {
        this.fillPolicy = fillPolicy;
        this.fillValue = fillValue;
        this.timeDurationThreshold = timeDurationThreshold;
    }

    public void serialize(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((int)this.fillPolicy.ordinal(), (ByteBuffer)byteBuffer);
        if (this.fillPolicy == FillPolicy.VALUE) {
            this.fillValue.serialize(byteBuffer);
        }
        ReadWriteIOUtils.write((Boolean)(this.timeDurationThreshold != null ? 1 : 0), (ByteBuffer)byteBuffer);
        if (this.timeDurationThreshold != null) {
            this.timeDurationThreshold.serialize(byteBuffer);
        }
    }

    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((int)this.fillPolicy.ordinal(), (OutputStream)stream);
        if (this.fillPolicy == FillPolicy.VALUE) {
            this.fillValue.serialize(stream);
        }
        ReadWriteIOUtils.write((Boolean)(this.timeDurationThreshold != null ? 1 : 0), (OutputStream)stream);
        if (this.timeDurationThreshold != null) {
            this.timeDurationThreshold.serialize(stream);
        }
    }

    public static FillDescriptor deserialize(ByteBuffer byteBuffer) {
        FillPolicy fillPolicy = FillPolicy.values()[ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer)];
        Literal fillValue = null;
        if (fillPolicy == FillPolicy.VALUE) {
            fillValue = Literal.deserialize(byteBuffer);
        }
        boolean hasTimeDurationThreshold = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        TimeDuration timeDurationThreshold = null;
        if (hasTimeDurationThreshold) {
            timeDurationThreshold = TimeDuration.deserialize((ByteBuffer)byteBuffer);
        }
        return new FillDescriptor(fillPolicy, fillValue, timeDurationThreshold);
    }

    public FillPolicy getFillPolicy() {
        return this.fillPolicy;
    }

    public Literal getFillValue() {
        return this.fillValue;
    }

    public TimeDuration getTimeDurationThreshold() {
        return this.timeDurationThreshold;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FillDescriptor that = (FillDescriptor)o;
        return this.fillPolicy == that.fillPolicy && Objects.equals(this.fillValue, that.fillValue);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fillPolicy, this.fillValue});
    }
}

