/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.source.dataregion.realtime.assigner;

import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import org.apache.iotdb.commons.concurrent.IoTDBDaemonThreadFactory;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.pipe.event.common.heartbeat.PipeHeartbeatEvent;
import org.apache.iotdb.db.pipe.event.realtime.PipeRealtimeEvent;
import org.apache.iotdb.db.pipe.resource.PipeDataNodeResourceManager;
import org.apache.iotdb.db.pipe.resource.memory.PipeMemoryBlock;
import org.apache.iotdb.db.pipe.source.dataregion.realtime.assigner.DisruptorQueueExceptionHandler;

public class DisruptorQueue {
    private static final IoTDBDaemonThreadFactory THREAD_FACTORY = new IoTDBDaemonThreadFactory(ThreadName.PIPE_EXTRACTOR_DISRUPTOR.getName());
    private final PipeMemoryBlock allocatedMemoryBlock;
    private final Disruptor<EventContainer> disruptor;
    private final RingBuffer<EventContainer> ringBuffer;
    private volatile boolean isClosed = false;

    public DisruptorQueue(EventHandler<PipeRealtimeEvent> eventHandler, Consumer<PipeRealtimeEvent> onAssignedHook) {
        PipeConfig config = PipeConfig.getInstance();
        int ringBufferSize = config.getPipeSourceAssignerDisruptorRingBufferSize();
        long ringBufferEntrySizeInBytes = config.getPipeSourceAssignerDisruptorRingBufferEntrySizeInBytes();
        this.allocatedMemoryBlock = PipeDataNodeResourceManager.memory().tryAllocate((long)ringBufferSize * ringBufferEntrySizeInBytes, currentSize -> currentSize / 2L);
        this.disruptor = new Disruptor(() -> new EventContainer(), Math.max(32, Math.toIntExact(this.allocatedMemoryBlock.getMemoryUsageInBytes() / ringBufferEntrySizeInBytes)), (ThreadFactory)THREAD_FACTORY, ProducerType.MULTI, (WaitStrategy)new BlockingWaitStrategy());
        this.disruptor.handleEventsWith(new EventHandler[]{(container, sequence, endOfBatch) -> {
            PipeRealtimeEvent realtimeEvent = container.getEvent();
            eventHandler.onEvent((Object)realtimeEvent, sequence, endOfBatch);
            onAssignedHook.accept(realtimeEvent);
        }});
        this.disruptor.setDefaultExceptionHandler((ExceptionHandler)new DisruptorQueueExceptionHandler());
        this.ringBuffer = this.disruptor.start();
    }

    public void publish(PipeRealtimeEvent event) {
        EnrichedEvent innerEvent = event.getEvent();
        if (innerEvent instanceof PipeHeartbeatEvent) {
            ((PipeHeartbeatEvent)innerEvent).recordDisruptorSize(this.ringBuffer);
        }
        this.ringBuffer.publishEvent((container, sequence, o) -> container.setEvent(event), (Object)event);
    }

    public void shutdown() {
        this.isClosed = true;
        this.disruptor.shutdown();
        this.allocatedMemoryBlock.close();
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    private static class EventContainer {
        private PipeRealtimeEvent event;

        private EventContainer() {
        }

        public PipeRealtimeEvent getEvent() {
            return this.event;
        }

        public void setEvent(PipeRealtimeEvent event) {
            this.event = event;
        }
    }
}

