/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence.partition;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class RegionGroup {
    private long createTime;
    private final TRegionReplicaSet replicaSet;
    private final Map<TSeriesPartitionSlot, AtomicLong> slotCountMap;
    private final AtomicLong totalTimeSlotCount;

    public RegionGroup() {
        this.createTime = 0L;
        this.replicaSet = new TRegionReplicaSet();
        this.slotCountMap = new ConcurrentHashMap<TSeriesPartitionSlot, AtomicLong>();
        this.totalTimeSlotCount = new AtomicLong();
    }

    public RegionGroup(long createTime, TRegionReplicaSet replicaSet) {
        this.createTime = createTime;
        this.replicaSet = replicaSet;
        this.slotCountMap = new ConcurrentHashMap<TSeriesPartitionSlot, AtomicLong>();
        this.totalTimeSlotCount = new AtomicLong(0L);
    }

    public synchronized long getCreateTime() {
        return this.createTime;
    }

    public synchronized TConsensusGroupId getId() {
        return this.replicaSet.getRegionId();
    }

    public synchronized TRegionReplicaSet getReplicaSet() {
        return this.replicaSet.deepCopy();
    }

    public synchronized void updateDataNode(TDataNodeLocation newDataNodeLocation) {
        for (int i = 0; i < this.replicaSet.getDataNodeLocationsSize(); ++i) {
            if (((TDataNodeLocation)this.replicaSet.getDataNodeLocations().get(i)).getDataNodeId() != newDataNodeLocation.getDataNodeId()) continue;
            this.replicaSet.getDataNodeLocations().set(i, newDataNodeLocation);
            return;
        }
    }

    public synchronized void addRegionLocation(TDataNodeLocation node) {
        this.replicaSet.addToDataNodeLocations(node);
        this.replicaSet.getDataNodeLocations().sort(TDataNodeLocation::compareTo);
    }

    public synchronized void removeRegionLocation(int nodeId) {
        this.replicaSet.getDataNodeLocations().removeIf(tDataNodeLocation -> nodeId == tDataNodeLocation.getDataNodeId());
        this.replicaSet.getDataNodeLocations().sort(TDataNodeLocation::compareTo);
    }

    public synchronized void updateSlotCountMap(Map<TSeriesPartitionSlot, AtomicLong> deltaMap) {
        deltaMap.forEach((seriesPartitionSlot, delta) -> {
            this.slotCountMap.computeIfAbsent((TSeriesPartitionSlot)seriesPartitionSlot, empty -> new AtomicLong(0L)).getAndAdd(delta.get());
            this.totalTimeSlotCount.getAndAdd(delta.get());
        });
    }

    public synchronized int getSeriesSlotCount() {
        return this.slotCountMap.size();
    }

    public synchronized long getTimeSlotCount() {
        return this.totalTimeSlotCount.get();
    }

    public synchronized boolean belongsToDataNode(int dataNodeId) {
        return this.replicaSet.getDataNodeLocations().stream().anyMatch(dataNodeLocation -> dataNodeLocation.getDataNodeId() == dataNodeId);
    }

    public synchronized void serialize(OutputStream outputStream, TProtocol protocol) throws IOException, TException {
        ReadWriteIOUtils.write((long)this.createTime, (OutputStream)outputStream);
        this.replicaSet.write(protocol);
        ReadWriteIOUtils.write((int)this.slotCountMap.size(), (OutputStream)outputStream);
        for (Map.Entry<TSeriesPartitionSlot, AtomicLong> slotCountEntry : this.slotCountMap.entrySet()) {
            slotCountEntry.getKey().write(protocol);
            ReadWriteIOUtils.write((long)slotCountEntry.getValue().get(), (OutputStream)outputStream);
        }
        ReadWriteIOUtils.write((long)this.totalTimeSlotCount.get(), (OutputStream)outputStream);
    }

    public synchronized void deserialize(InputStream inputStream, TProtocol protocol) throws IOException, TException {
        this.createTime = ReadWriteIOUtils.readLong((InputStream)inputStream);
        this.replicaSet.read(protocol);
        int size = ReadWriteIOUtils.readInt((InputStream)inputStream);
        for (int i = 0; i < size; ++i) {
            TSeriesPartitionSlot seriesPartitionSlot = new TSeriesPartitionSlot();
            seriesPartitionSlot.read(protocol);
            AtomicLong slotCount = new AtomicLong(ReadWriteIOUtils.readLong((InputStream)inputStream));
            this.slotCountMap.put(seriesPartitionSlot, slotCount);
        }
        this.totalTimeSlotCount.set(ReadWriteIOUtils.readLong((InputStream)inputStream));
    }

    public synchronized boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegionGroup that = (RegionGroup)o;
        for (Map.Entry<TSeriesPartitionSlot, AtomicLong> slotCountEntry : this.slotCountMap.entrySet()) {
            if (!that.slotCountMap.containsKey(slotCountEntry.getKey())) {
                return false;
            }
            if (slotCountEntry.getValue().get() == that.slotCountMap.get(slotCountEntry.getKey()).get()) continue;
            return false;
        }
        return this.createTime == that.createTime && this.replicaSet.equals(that.replicaSet) && this.totalTimeSlotCount.get() == that.totalTimeSlotCount.get();
    }

    public synchronized int hashCode() {
        return Objects.hash(this.createTime, this.replicaSet, this.slotCountMap, this.totalTimeSlotCount);
    }
}

