/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process;

import com.google.common.util.concurrent.ListenableFuture;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.ProcessOperator;
import org.apache.iotdb.db.utils.columngenerator.ColumnGenerator;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.utils.RamUsageEstimator;

public class ColumnInjectOperator
implements ProcessOperator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(ColumnInjectOperator.class);
    private final OperatorContext operatorContext;
    private final Operator child;
    private final int targetInjectIndex;
    private final ColumnGenerator columnGenerator;
    private final long maxExtraColumnSize;

    public ColumnInjectOperator(OperatorContext operatorContext, Operator childOperator, ColumnGenerator columnGenerator, int targetInjectIndex, long maxExtraColumnSize) {
        this.columnGenerator = columnGenerator;
        this.operatorContext = operatorContext;
        this.child = childOperator;
        this.targetInjectIndex = targetInjectIndex;
        this.maxExtraColumnSize = maxExtraColumnSize;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public TsBlock next() throws Exception {
        if (!this.child.hasNextWithTimer()) {
            return null;
        }
        TsBlock tsBlock = this.child.nextWithTimer();
        if (tsBlock == null) {
            return null;
        }
        Column[] columnsToBeInjected = this.columnGenerator.generate(tsBlock.getPositionCount());
        tsBlock = this.targetInjectIndex == tsBlock.getValueColumnCount() ? tsBlock.appendValueColumns(columnsToBeInjected) : tsBlock.insertValueColumn(this.targetInjectIndex, columnsToBeInjected);
        return tsBlock;
    }

    @Override
    public boolean hasNext() throws Exception {
        return this.child.hasNextWithTimer();
    }

    @Override
    public boolean isFinished() throws Exception {
        return !this.hasNextWithTimer();
    }

    @Override
    public void close() throws Exception {
        this.child.close();
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.child.isBlocked();
    }

    @Override
    public long calculateMaxPeekMemory() {
        return this.child.calculateMaxPeekMemoryWithCounter() + this.maxExtraColumnSize;
    }

    @Override
    public long calculateMaxReturnSize() {
        return this.maxExtraColumnSize + this.child.calculateMaxReturnSize();
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return this.child.calculateRetainedSizeAfterCallingNext();
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.child) + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.operatorContext);
    }
}

