/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.seata.integration.tx.api.interceptor.parser;

import org.apache.seata.integration.tx.api.interceptor.handler.GlobalTransactionalInterceptorHandler;
import org.apache.seata.integration.tx.api.interceptor.handler.ProxyInvocationHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

import static org.assertj.core.api.Assertions.assertThat;

public class CombineTransactionalInterceptorParserTest {

    @Test
    void parserInterfaceToProxy() throws Exception {

        // given
        BusinessCombineImpl business = new BusinessCombineImpl();

        GlobalTransactionalInterceptorParser globalTransactionalInterceptorParser =
                new GlobalTransactionalInterceptorParser();

        // when
        ProxyInvocationHandler proxyInvocationHandler = globalTransactionalInterceptorParser.parserInterfaceToProxy(
                business, business.getClass().getName());

        // then
        Assertions.assertNotNull(proxyInvocationHandler);

        // given
        CombineTransactionalInterceptorParser combineTransactionalInterceptorParser =
                new CombineTransactionalInterceptorParser();

        // when
        ProxyInvocationHandler proxyInvocationHandler2 = combineTransactionalInterceptorParser.parserInterfaceToProxy(
                business, business.getClass().getName());

        // then
        Assertions.assertNotNull(proxyInvocationHandler2);
    }

    @Test
    void parserInterfaceToProxyGlobalTransactionalIsFirst() throws Exception {
        // given
        BusinessCombineImpl business = new BusinessCombineImpl();

        // when
        ProxyInvocationHandler proxyInvocationHandler = DefaultInterfaceParser.get()
                .parserInterfaceToProxy(business, business.getClass().getName());

        // then
        assertThat(proxyInvocationHandler)
                .as("Proxy order verification")
                .isNotNull()
                .isInstanceOf(GlobalTransactionalInterceptorHandler.class);
    }
}
