/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.seata.spring.boot.autoconfigure.properties;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TransportPropertiesTest {

    @Test
    public void testTransportProperties() {
        TransportProperties transportProperties = new TransportProperties();
        transportProperties.setServer("server");
        transportProperties.setType("type");
        transportProperties.setSerialization("serialization");
        transportProperties.setCompressor("compressor");
        transportProperties.setHeartbeat(true);
        transportProperties.setEnableClientBatchSendRequest(true);
        transportProperties.setEnableRmClientBatchSendRequest(true);
        transportProperties.setEnableTmClientBatchSendRequest(true);
        transportProperties.setEnableTcServerBatchSendResponse(true);
        transportProperties.setRpcRmRequestTimeout(1);
        transportProperties.setRpcTmRequestTimeout(1);
        transportProperties.setRpcTcRequestTimeout(1);
        transportProperties.setEnableClientSharedEventLoop(true);
        transportProperties.setMinHttpPoolSize(20);
        transportProperties.setMaxHttpPoolSize(200);
        transportProperties.setMaxHttpTaskQueueSize(2000);
        transportProperties.setHttpPoolKeepAliveTime(600);
        transportProperties.setServerSocketSendBufSize(1024);
        transportProperties.setServerSocketResvBufSize(2048);
        transportProperties.setWriteBufferHighWaterMark(65536);
        transportProperties.setWriteBufferLowWaterMark(32768);
        transportProperties.setSoBackLogSize(512);
        transportProperties.setServerChannelMaxIdleTimeSeconds(60);
        transportProperties.setMinServerPoolSize(100);
        transportProperties.setMaxServerPoolSize(1000);
        transportProperties.setMaxTaskQueueSize(50000);
        transportProperties.setKeepAliveTime(1000);

        Assertions.assertEquals("server", transportProperties.getServer());
        Assertions.assertEquals("type", transportProperties.getType());
        Assertions.assertEquals("serialization", transportProperties.getSerialization());
        Assertions.assertEquals("compressor", transportProperties.getCompressor());
        Assertions.assertTrue(transportProperties.isHeartbeat());
        Assertions.assertTrue(transportProperties.isEnableClientBatchSendRequest());
        Assertions.assertTrue(transportProperties.isEnableRmClientBatchSendRequest());
        Assertions.assertTrue(transportProperties.isEnableTmClientBatchSendRequest());
        Assertions.assertTrue(transportProperties.isEnableTcServerBatchSendResponse());
        Assertions.assertEquals(1, transportProperties.getRpcRmRequestTimeout());
        Assertions.assertEquals(1, transportProperties.getRpcTmRequestTimeout());
        Assertions.assertEquals(1, transportProperties.getRpcTcRequestTimeout());
        Assertions.assertTrue(transportProperties.isEnableClientSharedEventLoop());
        Assertions.assertEquals(20, transportProperties.getMinHttpPoolSize());
        Assertions.assertEquals(200, transportProperties.getMaxHttpPoolSize());
        Assertions.assertEquals(2000, transportProperties.getMaxHttpTaskQueueSize());
        Assertions.assertEquals(600, transportProperties.getHttpPoolKeepAliveTime());
        Assertions.assertEquals(1024, transportProperties.getServerSocketSendBufSize());
        Assertions.assertEquals(2048, transportProperties.getServerSocketResvBufSize());
        Assertions.assertEquals(65536, transportProperties.getWriteBufferHighWaterMark());
        Assertions.assertEquals(32768, transportProperties.getWriteBufferLowWaterMark());
        Assertions.assertEquals(512, transportProperties.getSoBackLogSize());
        Assertions.assertEquals(60, transportProperties.getServerChannelMaxIdleTimeSeconds());
        Assertions.assertEquals(100, transportProperties.getMinServerPoolSize());
        Assertions.assertEquals(1000, transportProperties.getMaxServerPoolSize());
        Assertions.assertEquals(50000, transportProperties.getMaxTaskQueueSize());
        Assertions.assertEquals(1000, transportProperties.getKeepAliveTime());
    }
}
