/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.serialization;

import java.util.Objects;
import org.apache.ignite.internal.network.serialization.ClassDescriptor;
import org.jetbrains.annotations.Nullable;

public class MergedLayer {
    @Nullable
    private final ClassDescriptor localLayer;
    @Nullable
    private final ClassDescriptor remoteLayer;

    public static MergedLayer localOnly(ClassDescriptor localLayer) {
        return new MergedLayer(localLayer, null);
    }

    public static MergedLayer remoteOnly(ClassDescriptor remoteLayer) {
        return new MergedLayer(null, remoteLayer);
    }

    public MergedLayer(@Nullable ClassDescriptor localLayer, @Nullable ClassDescriptor remoteLayer) {
        assert (localLayer != null || remoteLayer != null) : "Both descriptors are null";
        assert (localLayer == null || remoteLayer == null || Objects.equals(localLayer.className(), remoteLayer.className())) : "Descriptors of different classes: " + localLayer.className() + " and " + remoteLayer.className();
        this.localLayer = localLayer;
        this.remoteLayer = remoteLayer;
    }

    public boolean hasLocal() {
        return this.localLayer != null;
    }

    public ClassDescriptor local() {
        return Objects.requireNonNull(this.localLayer, "localLayer is null");
    }

    public boolean hasRemote() {
        return this.remoteLayer != null;
    }

    public ClassDescriptor remote() {
        return Objects.requireNonNull(this.remoteLayer, "remoteLayer is null");
    }
}

