/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.aggregator;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hugegraph.computer.core.aggregator.Aggregator;
import org.apache.hugegraph.computer.core.aggregator.RegisterAggregators;
import org.apache.hugegraph.computer.core.graph.value.Value;
import org.apache.hugegraph.computer.core.rpc.AggregateRpcService;
import org.apache.hugegraph.util.E;

public class Aggregators {
    private final Map<String, Aggregator<? extends Value>> aggregators;

    public Aggregators() {
        this((Map<String, Aggregator<? extends Value>>)ImmutableMap.of());
    }

    public Aggregators(Map<String, Aggregator<? extends Value>> aggrs) {
        this.aggregators = new ConcurrentHashMap<String, Aggregator<? extends Value>>(aggrs);
    }

    public Map<String, Value> values() {
        HashMap<String, Value> values = new HashMap<String, Value>();
        for (Map.Entry<String, Aggregator<? extends Value>> aggr : this.aggregators.entrySet()) {
            values.put(aggr.getKey(), aggr.getValue().aggregatedValue());
        }
        return values;
    }

    public <V extends Value> Aggregator<V> get(String name, AggregateRpcService service) {
        Object aggregator = this.aggregators.get(name);
        if (aggregator == null) {
            if (service != null && (aggregator = service.getAggregator(name)) != null) {
                this.aggregators.put(name, (Aggregator<? extends Value>)aggregator);
            }
            E.checkArgument((aggregator != null ? 1 : 0) != 0, (String)"Can't get aggregator '%s'", (Object[])new Object[]{name});
        }
        Aggregator<? extends Value> result = aggregator;
        return result;
    }

    public void reset(RegisterAggregators register) {
        this.aggregators.clear();
        this.aggregators.putAll(register.copyAll());
    }

    public void clear() {
        this.aggregators.clear();
    }
}

