/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.HashMap;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.metrics.BaseSourceImpl;
import org.apache.hadoop.hbase.regionserver.MetricsTableLatencies;
import org.apache.hadoop.metrics2.MetricHistogram;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.DynamicMetricsRegistry;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MetricsTableLatenciesImpl
extends BaseSourceImpl
implements MetricsTableLatencies {
    private final HashMap<TableName, TableHistograms> histogramsByTable = new HashMap();

    @VisibleForTesting
    public static String qualifyMetricsName(TableName tableName, String metric) {
        StringBuilder sb = new StringBuilder();
        sb.append("Namespace_").append(tableName.getNamespaceAsString());
        sb.append("_table_").append(tableName.getQualifierAsString());
        sb.append("_metric_").append(metric);
        return sb.toString();
    }

    @VisibleForTesting
    public TableHistograms getOrCreateTableHistogram(String tableName) {
        TableName tn = TableName.valueOf(tableName);
        TableHistograms latency = this.histogramsByTable.get(tn);
        if (latency == null) {
            latency = new TableHistograms(this.getMetricsRegistry(), tn);
            this.histogramsByTable.put(tn, latency);
        }
        return latency;
    }

    public MetricsTableLatenciesImpl() {
        this("TableLatencies", "Metrics about Tables on a single HBase RegionServer", "regionserver", "RegionServer,sub=TableLatencies");
    }

    public MetricsTableLatenciesImpl(String metricsName, String metricsDescription, String metricsContext, String metricsJmxContext) {
        super(metricsName, metricsDescription, metricsContext, metricsJmxContext);
    }

    @Override
    public void updatePut(String tableName, long t) {
        this.getOrCreateTableHistogram(tableName).updatePut(t);
    }

    @Override
    public void updatePutBatch(String tableName, long t) {
        this.getOrCreateTableHistogram(tableName).updatePutBatch(t);
    }

    @Override
    public void updateDelete(String tableName, long t) {
        this.getOrCreateTableHistogram(tableName).updateDelete(t);
    }

    @Override
    public void updateDeleteBatch(String tableName, long t) {
        this.getOrCreateTableHistogram(tableName).updateDeleteBatch(t);
    }

    @Override
    public void updateGet(String tableName, long t) {
        this.getOrCreateTableHistogram(tableName).updateGet(t);
    }

    @Override
    public void updateIncrement(String tableName, long t) {
        this.getOrCreateTableHistogram(tableName).updateIncrement(t);
    }

    @Override
    public void updateAppend(String tableName, long t) {
        this.getOrCreateTableHistogram(tableName).updateAppend(t);
    }

    @Override
    public void updateScanSize(String tableName, long scanSize) {
        this.getOrCreateTableHistogram(tableName).updateScanSize(scanSize);
    }

    @Override
    public void updateScanTime(String tableName, long t) {
        this.getOrCreateTableHistogram(tableName).updateScanTime(t);
    }

    @Override
    public void getMetrics(MetricsCollector metricsCollector, boolean all) {
        MetricsRecordBuilder mrb = metricsCollector.addRecord(this.metricsName);
        this.metricsRegistry.snapshot(mrb, all);
        if (this.metricsAdapter != null) {
            this.metricsAdapter.snapshotAllMetrics(this.registry, mrb);
        }
    }

    @VisibleForTesting
    public static class TableHistograms {
        final MetricHistogram getTimeHisto;
        final MetricHistogram incrementTimeHisto;
        final MetricHistogram appendTimeHisto;
        final MetricHistogram putTimeHisto;
        final MetricHistogram putBatchTimeHisto;
        final MetricHistogram deleteTimeHisto;
        final MetricHistogram deleteBatchTimeHisto;
        final MetricHistogram scanTimeHisto;
        final MetricHistogram scanSizeHisto;

        TableHistograms(DynamicMetricsRegistry registry, TableName tn) {
            this.getTimeHisto = registry.newTimeHistogram(MetricsTableLatenciesImpl.qualifyMetricsName(tn, "getTime"));
            this.incrementTimeHisto = registry.newTimeHistogram(MetricsTableLatenciesImpl.qualifyMetricsName(tn, "incrementTime"));
            this.appendTimeHisto = registry.newTimeHistogram(MetricsTableLatenciesImpl.qualifyMetricsName(tn, "appendTime"));
            this.putTimeHisto = registry.newTimeHistogram(MetricsTableLatenciesImpl.qualifyMetricsName(tn, "putTime"));
            this.putBatchTimeHisto = registry.newTimeHistogram(MetricsTableLatenciesImpl.qualifyMetricsName(tn, "putBatchTime"));
            this.deleteTimeHisto = registry.newTimeHistogram(MetricsTableLatenciesImpl.qualifyMetricsName(tn, "deleteTime"));
            this.deleteBatchTimeHisto = registry.newTimeHistogram(MetricsTableLatenciesImpl.qualifyMetricsName(tn, "deleteBatchTime"));
            this.scanTimeHisto = registry.newTimeHistogram(MetricsTableLatenciesImpl.qualifyMetricsName(tn, "scanTime"));
            this.scanSizeHisto = registry.newSizeHistogram(MetricsTableLatenciesImpl.qualifyMetricsName(tn, "scanSize"));
        }

        public void updatePut(long time) {
            this.putTimeHisto.add(time);
        }

        public void updatePutBatch(long time) {
            this.putBatchTimeHisto.add(time);
        }

        public void updateDelete(long t) {
            this.deleteTimeHisto.add(t);
        }

        public void updateDeleteBatch(long t) {
            this.deleteBatchTimeHisto.add(t);
        }

        public void updateGet(long t) {
            this.getTimeHisto.add(t);
        }

        public void updateIncrement(long t) {
            this.incrementTimeHisto.add(t);
        }

        public void updateAppend(long t) {
            this.appendTimeHisto.add(t);
        }

        public void updateScanSize(long scanSize) {
            this.scanSizeHisto.add(scanSize);
        }

        public void updateScanTime(long t) {
            this.scanTimeHisto.add(t);
        }
    }
}

