/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.observation.interceptors;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hc.client5.http.classic.ExecChain;
import org.apache.hc.client5.http.classic.ExecChainHandler;
import org.apache.hc.client5.http.observation.MetricConfig;
import org.apache.hc.client5.http.observation.ObservingOptions;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.util.Args;

public final class TimerExec
implements ExecChainHandler {
    private final MeterRegistry registry;
    private final ObservingOptions cfg;
    private final MetricConfig mc;
    private final Timer.Builder timerBuilder;
    private final Counter.Builder counterBuilder;
    private final AtomicInteger inflight = new AtomicInteger(0);

    public TimerExec(MeterRegistry reg, ObservingOptions cfg) {
        this(reg, cfg, null);
    }

    public TimerExec(MeterRegistry reg, ObservingOptions cfg, MetricConfig mc) {
        this.registry = (MeterRegistry)Args.notNull((Object)reg, (String)"registry");
        this.cfg = (ObservingOptions)Args.notNull((Object)cfg, (String)"config");
        this.mc = mc != null ? mc : MetricConfig.builder().build();
        String base = this.mc.prefix + ".";
        this.timerBuilder = Timer.builder((String)(base + "request")).tags(this.mc.commonTags);
        if (this.mc.percentiles != null && this.mc.percentiles.length > 0) {
            this.timerBuilder.publishPercentiles(this.mc.percentiles);
        }
        if (this.mc.slo != null) {
            this.timerBuilder.serviceLevelObjectives(new Duration[]{this.mc.slo});
        }
        this.counterBuilder = Counter.builder((String)(base + "response")).tags(this.mc.commonTags);
        if (this.registry.find(this.mc.prefix + ".inflight").tags(new String[]{"kind", "classic"}).tags(this.mc.commonTags).gauge() == null) {
            Gauge.builder((String)(this.mc.prefix + ".inflight"), (Object)this.inflight, AtomicInteger::doubleValue).tag("kind", "classic").tags(this.mc.commonTags).register(this.registry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassicHttpResponse execute(ClassicHttpRequest request, ExecChain.Scope scope, ExecChain chain) throws IOException, HttpException {
        ClassicHttpResponse classicHttpResponse;
        if (!this.cfg.spanSampling.test(request.getRequestUri())) {
            return chain.proceed(request, scope);
        }
        this.inflight.incrementAndGet();
        long start = System.nanoTime();
        ClassicHttpResponse response = null;
        try {
            classicHttpResponse = response = chain.proceed(request, scope);
        }
        catch (Throwable throwable) {
            try {
                long durNanos = System.nanoTime() - start;
                int status = response != null ? response.getCode() : 599;
                ArrayList<Tag> tags = new ArrayList<Tag>(4);
                tags.add(Tag.of((String)"method", (String)request.getMethod()));
                tags.add(Tag.of((String)"status", (String)Integer.toString(status)));
                if (this.cfg.tagLevel == ObservingOptions.TagLevel.EXTENDED) {
                    tags.add(Tag.of((String)"protocol", (String)scope.route.getTargetHost().getSchemeName()));
                    tags.add(Tag.of((String)"target", (String)scope.route.getTargetHost().getHostName()));
                }
                this.timerBuilder.tags(tags).register(this.registry).record(durNanos, TimeUnit.NANOSECONDS);
                this.counterBuilder.tags(tags).register(this.registry).increment();
            }
            finally {
                this.inflight.decrementAndGet();
            }
            throw throwable;
        }
        try {
            long durNanos = System.nanoTime() - start;
            int status = response != null ? response.getCode() : 599;
            ArrayList<Tag> tags = new ArrayList<Tag>(4);
            tags.add(Tag.of((String)"method", (String)request.getMethod()));
            tags.add(Tag.of((String)"status", (String)Integer.toString(status)));
            if (this.cfg.tagLevel == ObservingOptions.TagLevel.EXTENDED) {
                tags.add(Tag.of((String)"protocol", (String)scope.route.getTargetHost().getSchemeName()));
                tags.add(Tag.of((String)"target", (String)scope.route.getTargetHost().getHostName()));
            }
            this.timerBuilder.tags(tags).register(this.registry).record(durNanos, TimeUnit.NANOSECONDS);
            this.counterBuilder.tags(tags).register(this.registry).increment();
        }
        finally {
            this.inflight.decrementAndGet();
        }
        return classicHttpResponse;
    }
}

