/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.Map;
import org.apache.hadoop.hive.common.type.SnapshotContext;
import org.apache.hive.common.util.SuppressFBWarnings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaterializationSnapshot {
    private static final Logger LOG = LoggerFactory.getLogger(MaterializationSnapshot.class);
    private String validTxnList;
    private Map<String, SnapshotContext> tableSnapshots;

    public static MaterializationSnapshot fromJson(String jsonString) {
        try {
            return (MaterializationSnapshot)new ObjectMapper().readValue(jsonString, MaterializationSnapshot.class);
        }
        catch (JsonProcessingException e) {
            LOG.warn(String.format("Unable to parse string as json '%s'. Falling back to parse it as a ValidTxnWriteIdList", jsonString), (Throwable)e);
            return new MaterializationSnapshot(jsonString);
        }
    }

    private MaterializationSnapshot() {
    }

    public MaterializationSnapshot(String validTxnList) {
        this.validTxnList = validTxnList;
        this.tableSnapshots = null;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Intended")
    public MaterializationSnapshot(Map<String, SnapshotContext> tableSnapshots) {
        this.validTxnList = null;
        this.tableSnapshots = tableSnapshots;
    }

    public String asJsonString() {
        String string;
        StringWriter out = new StringWriter();
        try {
            new ObjectMapper().writeValue((Writer)out, (Object)this);
            string = ((Object)out).toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Writer)out).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException("Unable to convert " + this + " to json", e);
            }
        }
        ((Writer)out).close();
        return string;
    }

    public String toString() {
        return "MaterializationSnapshot{validTxnList='" + this.validTxnList + "', tableSnapshots=" + this.tableSnapshots + "}";
    }

    public String getValidTxnList() {
        return this.validTxnList;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="intended")
    public Map<String, SnapshotContext> getTableSnapshots() {
        return this.tableSnapshots;
    }
}

