/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.NumberPrototypeBuiltinsFactory;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.cast.IsNumberNode;
import com.oracle.truffle.js.nodes.cast.JSDoubleToStringNode;
import com.oracle.truffle.js.nodes.cast.JSToDoubleNode;
import com.oracle.truffle.js.nodes.cast.JSToIntegerAsIntNode;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.intl.InitializeNumberFormatNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSException;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSNumber;
import com.oracle.truffle.js.runtime.builtins.JSNumberObject;
import com.oracle.truffle.js.runtime.builtins.intl.JSNumberFormat;
import com.oracle.truffle.js.runtime.builtins.intl.JSNumberFormatObject;
import com.oracle.truffle.js.runtime.objects.Undefined;

public final class NumberPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<NumberPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new NumberPrototypeBuiltins();

    protected NumberPrototypeBuiltins() {
        super(JSNumber.PROTOTYPE_NAME, NumberPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, NumberPrototype builtinEnum) {
        switch (builtinEnum) {
            case toExponential: {
                return NumberPrototypeBuiltinsFactory.JSNumberToExponentialNodeGen.create(context, builtin, NumberPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case toFixed: {
                return NumberPrototypeBuiltinsFactory.JSNumberToFixedNodeGen.create(context, builtin, NumberPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case toLocaleString: {
                if (context.isOptionIntl402()) {
                    return NumberPrototypeBuiltinsFactory.JSNumberToLocaleStringIntlNodeGen.create(context, builtin, NumberPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
                }
                return NumberPrototypeBuiltinsFactory.JSNumberToLocaleStringNodeGen.create(context, builtin, NumberPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case toPrecision: {
                return NumberPrototypeBuiltinsFactory.JSNumberToPrecisionNodeGen.create(context, builtin, NumberPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case toString: {
                return NumberPrototypeBuiltinsFactory.JSNumberToStringNodeGen.create(context, builtin, NumberPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case valueOf: {
                return NumberPrototypeBuiltinsFactory.JSNumberValueOfNodeGen.create(context, builtin, NumberPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
        }
        return null;
    }

    protected static double getDoubleValue(JSNumberObject obj) {
        return JSRuntime.doubleValue(obj.getNumber());
    }

    protected static double getDoubleValue(InteropLibrary interop, Object obj) {
        assert (JSGuards.isForeignObjectOrNumber(obj));
        try {
            if (interop.fitsInDouble(obj)) {
                return interop.asDouble(obj);
            }
            if (interop.fitsInBigInteger(obj)) {
                return BigInt.doubleValueOf(interop.asBigInteger(obj));
            }
        }
        catch (UnsupportedMessageException ex) {
            throw Errors.createTypeErrorUnboxException(obj, (InteropException)((Object)ex), (Node)interop);
        }
        throw Errors.createTypeErrorNotANumber(obj);
    }

    public static enum NumberPrototype implements BuiltinEnum<NumberPrototype>
    {
        toExponential(1),
        toFixed(1),
        toLocaleString(0),
        toPrecision(1),
        toString(1),
        valueOf(0);

        private final int length;

        private NumberPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }

    @ImportStatic(value={JSConfig.class})
    public static abstract class JSNumberToExponentialNode
    extends JSBuiltinNode {
        public JSNumberToExponentialNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isUndefined(fractionDigits)"})
        protected Object toExponentialUndefined(JSNumberObject thisNumber, Object fractionDigits) {
            double doubleValue = NumberPrototypeBuiltins.getDoubleValue(thisNumber);
            return JSNumberToExponentialNode.toExponentialStandard(doubleValue);
        }

        @Specialization(guards={"!isUndefined(fractionDigits)"})
        protected Object toExponential(JSNumberObject thisNumber, Object fractionDigits, @Cached.Shared @Cached InlinedBranchProfile digitsErrorBranch, @Cached.Shared @Cached JSToIntegerAsIntNode toIntegerNode) {
            double doubleValue = NumberPrototypeBuiltins.getDoubleValue(thisNumber);
            int digits = toIntegerNode.executeInt(fractionDigits);
            return this.toExponential(doubleValue, digits, this, digitsErrorBranch);
        }

        @Specialization(guards={"isNumber.execute(this, thisNumber)", "isUndefined(fractionDigits)"}, limit="1")
        protected static Object toExponentialPrimitiveUndefined(Object thisNumber, Object fractionDigits, @Cached.Shared @Cached IsNumberNode isNumber, @Cached.Shared @Cached JSToDoubleNode toDouble) {
            double doubleValue = toDouble.executeDouble(thisNumber);
            return JSNumberToExponentialNode.toExponentialStandard(doubleValue);
        }

        @Specialization(guards={"isNumber.execute(this, thisNumber)", "!isUndefined(fractionDigits)"}, limit="1")
        protected final Object toExponentialPrimitive(Object thisNumber, Object fractionDigits, @Cached.Shared @Cached IsNumberNode isNumber, @Cached.Shared @Cached JSToDoubleNode toDouble, @Cached.Shared @Cached InlinedBranchProfile digitsErrorBranch, @Cached.Shared @Cached JSToIntegerAsIntNode toIntegerNode) {
            double doubleValue = toDouble.executeDouble(thisNumber);
            int digits = toIntegerNode.executeInt(fractionDigits);
            return this.toExponential(doubleValue, digits, this, digitsErrorBranch);
        }

        @Specialization(guards={"isForeignObjectOrNumber(thisNumber)", "isUndefined(fractionDigits)"}, limit="InteropLibraryLimit")
        protected Object toExponentialForeignObjectUndefined(Object thisNumber, Object fractionDigits, @CachedLibrary(value="thisNumber") InteropLibrary interop) {
            double doubleValue = NumberPrototypeBuiltins.getDoubleValue(interop, thisNumber);
            return JSNumberToExponentialNode.toExponentialStandard(doubleValue);
        }

        @Specialization(guards={"isForeignObjectOrNumber(thisNumber)", "!isUndefined(fractionDigits)"}, limit="InteropLibraryLimit")
        protected Object toExponentialForeignObject(Object thisNumber, Object fractionDigits, @Bind(value="this") Node node, @Cached.Shared @Cached InlinedBranchProfile digitsErrorBranch, @Cached.Shared @Cached JSToIntegerAsIntNode toIntegerNode, @CachedLibrary(value="thisNumber") InteropLibrary interop) {
            double doubleValue = NumberPrototypeBuiltins.getDoubleValue(interop, thisNumber);
            int digits = toIntegerNode.executeInt(fractionDigits);
            return this.toExponential(doubleValue, digits, node, digitsErrorBranch);
        }

        @Specialization(guards={"!isJSNumber(thisNumber)", "!isNumber(thisNumber)", "!isForeignObjectOrNumber(thisNumber)"})
        protected Object toExponentialOther(Object thisNumber, Object fractionDigits) {
            throw Errors.createTypeErrorNotANumber(thisNumber);
        }

        private static Object toExponentialStandard(double value) {
            if (Double.isNaN(value)) {
                return Strings.NAN;
            }
            if (Double.isInfinite(value)) {
                return value < 0.0 ? Strings.NEGATIVE_INFINITY : Strings.INFINITY;
            }
            return JSRuntime.formatDtoAExponential(value);
        }

        private Object toExponential(double value, int digits, Node node, InlinedBranchProfile digitsErrorBranch) {
            if (Double.isNaN(value)) {
                return Strings.NAN;
            }
            if (Double.isInfinite(value)) {
                return value < 0.0 ? Strings.NEGATIVE_INFINITY : Strings.INFINITY;
            }
            this.checkDigits(digits, node, digitsErrorBranch);
            return JSRuntime.formatDtoAExponential(value, digits);
        }

        private void checkDigits(int digits, Node node, InlinedBranchProfile digitsErrorBranch) {
            int maxDigits;
            int n = maxDigits = this.getContext().getEcmaScriptVersion() >= 9 ? 100 : 20;
            if (0 > digits || digits > maxDigits) {
                digitsErrorBranch.enter(node);
                throw JSNumberToExponentialNode.digitsRangeError(maxDigits);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static JSException digitsRangeError(int maxDigits) {
            return Errors.createRangeError("toExponential() fraction digits need to be in range 0-" + maxDigits);
        }
    }

    @ImportStatic(value={JSConfig.class})
    public static abstract class JSNumberToFixedNode
    extends JSBuiltinNode {
        protected JSNumberToFixedNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object toFixed(JSNumberObject thisNumber, Object fractionDigits, @Cached.Shared @Cached JSToIntegerAsIntNode toIntegerNode, @Cached.Shared @Cached JSDoubleToStringNode doubleToString, @Cached.Shared @Cached InlinedBranchProfile digitsErrorBranch, @Cached.Shared @Cached InlinedBranchProfile nanBranch, @Cached.Shared @Cached InlinedConditionProfile dtoaOrString) {
            int digits = toIntegerNode.executeInt(fractionDigits);
            return this.toFixedIntl(NumberPrototypeBuiltins.getDoubleValue(thisNumber), digits, this, doubleToString, digitsErrorBranch, nanBranch, dtoaOrString);
        }

        @Specialization(guards={"isNumber.execute(this, thisNumber)"}, limit="1")
        protected Object toFixedJava(Object thisNumber, Object fractionDigits, @Cached IsNumberNode isNumber, @Cached.Shared @Cached JSToIntegerAsIntNode toIntegerNode, @Cached.Shared @Cached JSDoubleToStringNode doubleToString, @Cached.Shared @Cached InlinedBranchProfile digitsErrorBranch, @Cached.Shared @Cached InlinedBranchProfile nanBranch, @Cached.Shared @Cached InlinedConditionProfile dtoaOrString) {
            int digits = toIntegerNode.executeInt(fractionDigits);
            return this.toFixedIntl(JSRuntime.doubleValue((Number)thisNumber), digits, this, doubleToString, digitsErrorBranch, nanBranch, dtoaOrString);
        }

        @Specialization(guards={"isForeignObjectOrNumber(thisNumber)"}, limit="InteropLibraryLimit")
        protected Object toFixedForeignObject(Object thisNumber, Object fractionDigits, @Bind(value="this") Node node, @Cached.Shared @Cached JSToIntegerAsIntNode toIntegerNode, @Cached.Shared @Cached JSDoubleToStringNode doubleToString, @Cached.Shared @Cached InlinedBranchProfile digitsErrorBranch, @Cached.Shared @Cached InlinedBranchProfile nanBranch, @Cached.Shared @Cached InlinedConditionProfile dtoaOrString, @CachedLibrary(value="thisNumber") InteropLibrary interop) {
            double doubleValue = NumberPrototypeBuiltins.getDoubleValue(interop, thisNumber);
            int digits = toIntegerNode.executeInt(fractionDigits);
            return this.toFixedIntl(doubleValue, digits, node, doubleToString, digitsErrorBranch, nanBranch, dtoaOrString);
        }

        @Fallback
        protected Object toFixedGeneric(Object thisNumber, Object fractionDigits) {
            throw Errors.createTypeErrorNotANumber(thisNumber);
        }

        private Object toFixedIntl(double value, int digits, Node node, JSDoubleToStringNode doubleToString, InlinedBranchProfile digitsErrorBranch, InlinedBranchProfile nanBranch, InlinedConditionProfile dtoaOrString) {
            if (0 > digits || digits > (this.getContext().getEcmaScriptVersion() >= 9 ? 100 : 20)) {
                digitsErrorBranch.enter(node);
                throw Errors.createRangeError("toFixed() fraction digits need to be in range 0-100");
            }
            if (Double.isNaN(value)) {
                nanBranch.enter(node);
                return Strings.NAN;
            }
            if (dtoaOrString.profile(node, value >= 1.0E21 || value <= -1.0E21)) {
                return doubleToString.executeString(value);
            }
            return JSRuntime.formatDtoAFixed(value, digits);
        }
    }

    @ImportStatic(value={JSConfig.class})
    public static abstract class JSNumberToLocaleStringIntlNode
    extends JSBuiltinNode {
        @Node.Child
        InitializeNumberFormatNode initNumberFormatNode;

        public JSNumberToLocaleStringIntlNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.initNumberFormatNode = InitializeNumberFormatNode.createInitalizeNumberFormatNode(context);
        }

        @CompilerDirectives.TruffleBoundary
        private JSNumberFormatObject createNumberFormat(Object locales, Object options) {
            JSNumberFormatObject numberFormatObj = JSNumberFormat.create(this.getContext(), this.getRealm());
            this.initNumberFormatNode.executeInit(numberFormatObj, locales, options);
            return numberFormatObj;
        }

        @Specialization
        protected TruffleString jsNumberToLocaleString(JSNumberObject thisObj, Object locales, Object options) {
            JSNumberFormatObject numberFormatObj = this.createNumberFormat(locales, options);
            return JSNumberFormat.format(numberFormatObj, thisObj.getNumber());
        }

        @Specialization(guards={"isNumber.execute(this, thisNumber)"}, limit="1")
        protected final TruffleString javaNumberToLocaleString(Object thisNumber, Object locales, Object options, @Cached IsNumberNode isNumber, @Cached JSToDoubleNode toDouble) {
            double doubleValue = toDouble.executeDouble(thisNumber);
            JSNumberFormatObject numberFormatObj = this.createNumberFormat(locales, options);
            return JSNumberFormat.format(numberFormatObj, doubleValue);
        }

        @Specialization(guards={"isForeignObjectOrNumber(thisObj)"}, limit="InteropLibraryLimit")
        protected TruffleString toLocaleStringForeignObject(Object thisObj, Object locales, Object options, @CachedLibrary(value="thisObj") InteropLibrary interop) {
            double doubleValue = NumberPrototypeBuiltins.getDoubleValue(interop, thisObj);
            JSNumberFormatObject numberFormatObj = this.createNumberFormat(locales, options);
            return JSNumberFormat.format(numberFormatObj, doubleValue);
        }

        @Fallback
        protected Object failForNonNumbers(Object notANumber, Object locales, Object options) {
            throw Errors.createTypeErrorNotANumber(notANumber);
        }
    }

    @ImportStatic(value={JSConfig.class})
    public static abstract class JSNumberToLocaleStringNode
    extends JSBuiltinNode {
        public JSNumberToLocaleStringNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected static Object doNumberObject(JSNumberObject thisObj) {
            double d = NumberPrototypeBuiltins.getDoubleValue(thisObj);
            return JSRuntime.doubleToString(d);
        }

        @Specialization
        protected static Object doInt(int thisInteger) {
            return Strings.fromInt(thisInteger);
        }

        @Specialization(guards={"isNumber.execute(this, thisNumber)"}, limit="1")
        protected static Object doNumber(Object thisNumber, @Cached IsNumberNode isNumber, @Cached JSToDoubleNode toDouble) {
            double d = toDouble.executeDouble(thisNumber);
            return JSRuntime.doubleToString(d);
        }

        @Specialization(guards={"isForeignObjectOrNumber(thisObj)"}, limit="InteropLibraryLimit")
        protected static Object doForeign(Object thisObj, @CachedLibrary(value="thisObj") InteropLibrary interop) {
            return JSRuntime.doubleToString(NumberPrototypeBuiltins.getDoubleValue(interop, thisObj));
        }

        @Fallback
        protected String toLocaleStringOther(Object thisNumber) {
            throw Errors.createTypeErrorNotANumber(thisNumber);
        }
    }

    @ImportStatic(value={JSConfig.class})
    public static abstract class JSNumberToPrecisionNode
    extends JSBuiltinNode {
        public JSNumberToPrecisionNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isUndefined(precision)"})
        protected Object toPrecisionUndefined(JSNumberObject thisNumber, Object precision, @Cached.Shared @Cached JSToStringNode toStringNode) {
            return toStringNode.executeString((Object)thisNumber);
        }

        @Specialization(guards={"!isUndefined(precision)"})
        protected Object toPrecision(JSNumberObject thisNumber, Object precision, @Cached.Shared @Cached JSToNumberNode toNumberNode, @Cached.Shared @Cached InlinedBranchProfile errorBranch) {
            long lPrecision = JSRuntime.toInteger(toNumberNode.executeNumber(precision));
            double thisNumberVal = NumberPrototypeBuiltins.getDoubleValue(thisNumber);
            return this.toPrecisionIntl(thisNumberVal, lPrecision, this, errorBranch);
        }

        @Specialization(guards={"isNumber.execute(this, thisNumber)", "isUndefined(precision)"}, limit="1")
        protected static Object toPrecisionPrimitiveUndefined(Object thisNumber, Object precision, @Cached.Shared @Cached IsNumberNode isNumber, @Cached.Shared @Cached JSToStringNode toStringNode) {
            return toStringNode.executeString(thisNumber);
        }

        @Specialization(guards={"isNumber.execute(this, thisNumber)", "!isUndefined(precision)"}, limit="1")
        protected final Object toPrecisionPrimitive(Object thisNumber, Object precision, @Cached.Shared @Cached IsNumberNode isNumber, @Cached.Shared @Cached JSToNumberNode toNumberNode, @Cached.Shared @Cached InlinedBranchProfile errorBranch) {
            long lPrecision = JSRuntime.toInteger(toNumberNode.executeNumber(precision));
            double thisNumberVal = JSRuntime.doubleValue((Number)thisNumber);
            return this.toPrecisionIntl(thisNumberVal, lPrecision, this, errorBranch);
        }

        @Specialization(guards={"isForeignObjectOrNumber(thisNumber)", "isUndefined(precision)"}, limit="InteropLibraryLimit")
        protected Object toPrecisionForeignObjectUndefined(Object thisNumber, Object precision, @Cached.Shared @Cached JSToStringNode toStringNode, @CachedLibrary(value="thisNumber") InteropLibrary interop) {
            return toStringNode.executeString(NumberPrototypeBuiltins.getDoubleValue(interop, thisNumber));
        }

        @Specialization(guards={"isForeignObjectOrNumber(thisNumber)", "!isUndefined(precision)"}, limit="InteropLibraryLimit")
        protected Object toPrecisionForeignObject(Object thisNumber, Object precision, @Bind(value="this") Node node, @Cached.Shared @Cached JSToNumberNode toNumberNode, @Cached.Shared @Cached InlinedBranchProfile errorBranch, @CachedLibrary(value="thisNumber") InteropLibrary interop) {
            double thisNumberVal = NumberPrototypeBuiltins.getDoubleValue(interop, thisNumber);
            long lPrecision = JSRuntime.toInteger(toNumberNode.executeNumber(precision));
            return this.toPrecisionIntl(thisNumberVal, lPrecision, node, errorBranch);
        }

        @Specialization(guards={"!isJSNumber(thisNumber)", "!isNumber(thisNumber)", "!isForeignObjectOrNumber(thisNumber)"})
        protected Object toPrecisionOther(Object thisNumber, Object precision) {
            throw Errors.createTypeErrorNotANumber(thisNumber);
        }

        private Object toPrecisionIntl(double thisNumberVal, long lPrecision, Node node, InlinedBranchProfile errorBranch) {
            if (Double.isNaN(thisNumberVal)) {
                return Strings.NAN;
            }
            if (Double.isInfinite(thisNumberVal)) {
                return thisNumberVal < 0.0 ? Strings.NEGATIVE_INFINITY : Strings.INFINITY;
            }
            this.checkPrecision(lPrecision, node, errorBranch);
            return JSRuntime.formatDtoAPrecision(thisNumberVal, (int)lPrecision);
        }

        private void checkPrecision(long precision, Node node, InlinedBranchProfile errorBranch) {
            int maxPrecision;
            int n = maxPrecision = this.getContext().getEcmaScriptVersion() >= 9 ? 100 : 20;
            if (precision < 1L || precision > (long)maxPrecision) {
                errorBranch.enter(node);
                throw JSNumberToPrecisionNode.precisionRangeError(maxPrecision);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static JSException precisionRangeError(int maxPrecision) {
            return Errors.createRangeError("toPrecision() argument must be between 1 and " + maxPrecision);
        }
    }

    @ImportStatic(value={JSConfig.class})
    public static abstract class JSNumberToStringNode
    extends JSBuiltinNode {
        public JSNumberToStringNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        protected boolean isRadix10(Object radix) {
            return radix == Undefined.instance || radix instanceof Integer && (Integer)radix == 10;
        }

        protected static boolean isJSNumberInteger(JSNumberObject thisObj) {
            return thisObj.getNumber() instanceof Integer;
        }

        @Specialization(guards={"isJSNumberInteger(thisObj)", "isRadix10(radix)"})
        protected Object toStringIntRadix10(JSNumberObject thisObj, Object radix) {
            Integer i = (Integer)thisObj.getNumber();
            return Strings.fromInt(i);
        }

        @Specialization(guards={"isRadix10(radix)"})
        protected Object toStringRadix10(JSNumberObject thisObj, Object radix, @Cached.Shared @Cached JSDoubleToStringNode doubleToString) {
            return doubleToString.executeString(NumberPrototypeBuiltins.getDoubleValue(thisObj));
        }

        @Specialization(guards={"!isUndefined(radix)"})
        protected Object toString(JSNumberObject thisObj, Object radix, @Cached.Shared @Cached JSToIntegerAsIntNode toIntegerNode, @Cached.Shared @Cached JSDoubleToStringNode doubleToString, @Cached.Shared @Cached InlinedBranchProfile radixOtherBranch, @Cached.Shared @Cached InlinedBranchProfile radixErrorBranch) {
            return JSNumberToStringNode.toStringWithRadix(NumberPrototypeBuiltins.getDoubleValue(thisObj), radix, this, toIntegerNode, doubleToString, radixOtherBranch, radixErrorBranch);
        }

        @Specialization(guards={"isRadix10(radix)"})
        protected Object toStringPrimitiveIntRadix10(int thisInteger, Object radix) {
            return Strings.fromInt(thisInteger);
        }

        @Specialization(guards={"isNumber.execute(this, thisNumber)", "isRadix10(radix)"}, limit="1")
        protected Object toStringPrimitiveRadix10(Object thisNumber, Object radix, @Cached.Shared @Cached IsNumberNode isNumber, @Cached.Shared @Cached JSDoubleToStringNode doubleToString) {
            return doubleToString.executeString(thisNumber);
        }

        @Specialization(guards={"isNumber.execute(this, thisNumber)"}, limit="1")
        protected Object toStringPrimitiveRadixInt(Object thisNumber, int radix, @Cached.Shared @Cached IsNumberNode isNumber, @Cached.Shared @Cached JSToDoubleNode toDouble, @Cached.Shared @Cached JSDoubleToStringNode doubleToString, @Cached.Shared @Cached InlinedBranchProfile radixOtherBranch, @Cached.Shared @Cached InlinedBranchProfile radixErrorBranch) {
            double doubleValue = toDouble.executeDouble(thisNumber);
            return JSNumberToStringNode.toStringWithIntRadix(doubleValue, radix, this, doubleToString, radixOtherBranch, radixErrorBranch);
        }

        @Specialization(guards={"isNumber.execute(this, thisNumber)", "!isUndefined(radix)"}, limit="1", replaces={"toStringPrimitiveRadixInt"})
        protected Object toStringPrimitive(Object thisNumber, Object radix, @Cached.Shared @Cached IsNumberNode isNumber, @Cached.Shared @Cached JSToDoubleNode toDouble, @Cached.Shared @Cached JSToIntegerAsIntNode toIntegerNode, @Cached.Shared @Cached JSDoubleToStringNode doubleToString, @Cached.Shared @Cached InlinedBranchProfile radixOtherBranch, @Cached.Shared @Cached InlinedBranchProfile radixErrorBranch) {
            double doubleValue = toDouble.executeDouble(thisNumber);
            return JSNumberToStringNode.toStringWithRadix(doubleValue, radix, this, toIntegerNode, doubleToString, radixOtherBranch, radixErrorBranch);
        }

        @Specialization(guards={"isForeignObjectOrNumber(thisObj)"}, limit="InteropLibraryLimit")
        protected Object toStringForeignObject(Object thisObj, Object radix, @Bind(value="this") Node node, @Cached.Shared @Cached JSToIntegerAsIntNode toIntegerNode, @Cached.Shared @Cached JSDoubleToStringNode doubleToString, @Cached.Shared @Cached InlinedBranchProfile radixOtherBranch, @Cached.Shared @Cached InlinedBranchProfile radixErrorBranch, @CachedLibrary(value="thisObj") InteropLibrary interop) {
            return JSNumberToStringNode.toStringWithRadix(NumberPrototypeBuiltins.getDoubleValue(interop, thisObj), radix == Undefined.instance ? Integer.valueOf(10) : radix, node, toIntegerNode, doubleToString, radixOtherBranch, radixErrorBranch);
        }

        @Specialization(guards={"!isJSNumber(thisObj)", "!isNumber(thisObj)", "!isForeignObjectOrNumber(thisObj)"})
        protected String toStringNoNumber(Object thisObj, Object radix) {
            throw Errors.createTypeErrorNotANumber(thisObj);
        }

        private static Object toStringWithRadix(double numberVal, Object radix, Node node, JSToIntegerAsIntNode toIntegerNode, JSDoubleToStringNode doubleToString, InlinedBranchProfile radixOtherBranch, InlinedBranchProfile radixErrorBranch) {
            int radixVal = toIntegerNode.executeInt(radix);
            return JSNumberToStringNode.toStringWithIntRadix(numberVal, radixVal, node, doubleToString, radixOtherBranch, radixErrorBranch);
        }

        private static Object toStringWithIntRadix(double numberVal, int radixVal, Node node, JSDoubleToStringNode doubleToString, InlinedBranchProfile radixOtherBranch, InlinedBranchProfile radixErrorBranch) {
            if (radixVal < 2 || radixVal > 36) {
                radixErrorBranch.enter(node);
                throw Errors.createRangeError("toString() expects radix in range 2-36");
            }
            if (radixVal == 10) {
                return doubleToString.executeString(numberVal);
            }
            radixOtherBranch.enter(node);
            return JSRuntime.doubleToString(numberVal, radixVal);
        }
    }

    @ImportStatic(value={JSConfig.class})
    public static abstract class JSNumberValueOfNode
    extends JSBuiltinNode {
        public JSNumberValueOfNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected static Number valueOf(JSNumberObject thisNumber) {
            return thisNumber.getNumber();
        }

        @Specialization(guards={"isNumber.execute(this, thisNumber)"}, limit="1")
        protected static double valueOfPrimitive(Object thisNumber, @Cached IsNumberNode isNumber, @Cached JSToDoubleNode toDouble) {
            return toDouble.executeDouble(thisNumber);
        }

        @Specialization(guards={"isForeignObjectOrNumber(thisNumber)"}, limit="InteropLibraryLimit")
        protected static double valueOfForeignObject(Object thisNumber, @CachedLibrary(value="thisNumber") InteropLibrary interop) {
            return NumberPrototypeBuiltins.getDoubleValue(interop, thisNumber);
        }

        @Fallback
        protected static Object valueOfOther(Object thisNumber) {
            throw Errors.createTypeErrorNotANumber(thisNumber);
        }
    }
}

