/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Iterators;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.relocated.com.google.common.collect.Streams;

abstract class WrapperSet<T>
implements Set<T>,
Serializable {
    private final Set<Wrapper<T>> set = Sets.newLinkedHashSet();

    protected WrapperSet(Iterable<Wrapper<T>> wrappers) {
        wrappers.forEach(this.set::add);
    }

    protected WrapperSet() {
    }

    protected abstract Wrapper<T> wrapper();

    protected abstract Wrapper<T> wrap(T var1);

    protected abstract Class<T> elementClass();

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public boolean contains(Object obj) {
        Preconditions.checkNotNull(obj, "Invalid object: null");
        Wrapper<T> wrapper = this.wrapper();
        boolean result = this.set.contains(wrapper.set(this.elementClass().cast(obj)));
        wrapper.set(null);
        return result;
    }

    @Override
    public Iterator<T> iterator() {
        return Iterators.transform(this.set.iterator(), Wrapper::get);
    }

    @Override
    public Object[] toArray() {
        return Lists.newArrayList(this.iterator()).toArray();
    }

    @Override
    public <X> X[] toArray(X[] destArray) {
        return Lists.newArrayList(this.iterator()).toArray(destArray);
    }

    @Override
    public boolean add(T obj) {
        Preconditions.checkNotNull(obj, "Invalid object: null");
        return this.set.add(this.wrap(obj));
    }

    @Override
    public boolean remove(Object obj) {
        Preconditions.checkNotNull(obj, "Invalid object: null");
        Wrapper<T> wrapper = this.wrapper();
        boolean result = this.set.remove(wrapper.set(this.elementClass().cast(obj)));
        wrapper.set(null);
        return result;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        Preconditions.checkNotNull(collection, "Invalid collection: null");
        return Iterables.all(collection, this::contains);
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        Preconditions.checkNotNull(collection, "Invalid collection: null");
        return collection.stream().filter(this::add).count() != 0L;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        Preconditions.checkNotNull(collection, "Invalid collection: null");
        Set toRetain = collection.stream().map(obj -> Preconditions.checkNotNull(obj, "Invalid object: null")).map(this.elementClass()::cast).map(this::wrap).collect(Collectors.toSet());
        return Iterables.retainAll(this.set, toRetain);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        Preconditions.checkNotNull(collection, "Invalid collection: null");
        return collection.stream().filter(this::remove).count() != 0L;
    }

    @Override
    public void clear() {
        this.set.clear();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Set)) {
            return false;
        }
        Set that = (Set)other;
        if (this.size() != that.size()) {
            return false;
        }
        try {
            return this.containsAll(that);
        }
        catch (ClassCastException | NullPointerException unused) {
            return false;
        }
    }

    @Override
    public int hashCode() {
        return this.set.stream().mapToInt(Object::hashCode).sum();
    }

    public String toString() {
        return Streams.stream(this.iterator()).map(Object::toString).collect(Collectors.joining(", ", "[", "]"));
    }

    protected static interface Wrapper<T>
    extends Serializable {
        public T get();

        public Wrapper<T> set(T var1);
    }
}

