/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.udf;

import java.math.BigDecimal;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorConverter;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableDoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableFloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableHiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableIntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableLongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableConstantIntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableStringObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.iceberg.transforms.Transforms;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.SerializableFunction;

@Description(name="iceberg_truncate", value="_FUNC_(value, truncateLength) - Returns the bucket value calculated by Iceberg bucket transform function ", extended="Example:\n  > SELECT _FUNC_('abcdefgh', 5);\n  abcde")
public class GenericUDFIcebergTruncate
extends GenericUDF {
    private final Text result = new Text();
    private int truncateLength = 0;
    private transient PrimitiveObjectInspector argumentOI;
    private transient ObjectInspectorConverters.Converter converter;
    private transient UDFEvalFunction<GenericUDF.DeferredObject> evaluator;

    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 2) {
            throw new UDFArgumentLengthException("ICEBERG_BUCKET requires 2 arguments (value, bucketCount), but got " + arguments.length);
        }
        this.truncateLength = GenericUDFIcebergTruncate.getTruncateLength(arguments[1]);
        if (arguments[0].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentException("ICEBERG_BUCKET first argument takes primitive types, got " + this.argumentOI.getTypeName());
        }
        this.argumentOI = (PrimitiveObjectInspector)arguments[0];
        PrimitiveObjectInspector.PrimitiveCategory inputType = this.argumentOI.getPrimitiveCategory();
        switch (inputType) {
            case CHAR: 
            case VARCHAR: 
            case STRING: {
                this.converter = new PrimitiveObjectInspectorConverter.StringConverter(this.argumentOI);
                SerializableFunction stringTransform = Transforms.truncate(this.truncateLength).bind(Types.StringType.get());
                this.evaluator = arg -> {
                    String val = (String)this.converter.convert(arg.get());
                    this.result.set(String.valueOf(stringTransform.apply(val)));
                };
                break;
            }
            case INT: {
                this.converter = new PrimitiveObjectInspectorConverter.IntConverter(this.argumentOI, (SettableIntObjectInspector)PrimitiveObjectInspectorFactory.writableIntObjectInspector);
                SerializableFunction intTransform = Transforms.truncate(this.truncateLength).bind(Types.IntegerType.get());
                this.evaluator = arg -> {
                    IntWritable val = (IntWritable)this.converter.convert(arg.get());
                    this.result.set(String.valueOf(intTransform.apply(val.get())));
                };
                break;
            }
            case LONG: {
                this.converter = new PrimitiveObjectInspectorConverter.LongConverter(this.argumentOI, (SettableLongObjectInspector)PrimitiveObjectInspectorFactory.writableLongObjectInspector);
                SerializableFunction longTransform = Transforms.truncate(this.truncateLength).bind(Types.LongType.get());
                this.evaluator = arg -> {
                    LongWritable val = (LongWritable)this.converter.convert(arg.get());
                    this.result.set(String.valueOf(longTransform.apply(val.get())));
                };
                break;
            }
            case DECIMAL: {
                DecimalTypeInfo decimalTypeInfo = (DecimalTypeInfo)TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)this.argumentOI);
                Types.DecimalType decimalIcebergType = Types.DecimalType.of(decimalTypeInfo.getPrecision(), decimalTypeInfo.getScale());
                this.converter = new PrimitiveObjectInspectorConverter.HiveDecimalConverter(this.argumentOI, (SettableHiveDecimalObjectInspector)PrimitiveObjectInspectorFactory.writableHiveDecimalObjectInspector);
                SerializableFunction bigDecimalTransform = Transforms.truncate(this.truncateLength).bind(decimalIcebergType);
                this.evaluator = arg -> {
                    HiveDecimalWritable val = (HiveDecimalWritable)this.converter.convert(arg.get());
                    this.result.set(((BigDecimal)bigDecimalTransform.apply(val.getHiveDecimal().bigDecimalValue())).toPlainString());
                };
                break;
            }
            case FLOAT: {
                this.converter = new PrimitiveObjectInspectorConverter.FloatConverter(this.argumentOI, (SettableFloatObjectInspector)PrimitiveObjectInspectorFactory.writableFloatObjectInspector);
                SerializableFunction floatTransform = Transforms.truncate(this.truncateLength).bind(Types.FloatType.get());
                this.evaluator = arg -> {
                    FloatWritable val = (FloatWritable)this.converter.convert(arg.get());
                    this.result.set(String.valueOf(floatTransform.apply(Float.valueOf(val.get()))));
                };
                break;
            }
            case DOUBLE: {
                this.converter = new PrimitiveObjectInspectorConverter.DoubleConverter(this.argumentOI, (SettableDoubleObjectInspector)PrimitiveObjectInspectorFactory.writableDoubleObjectInspector);
                SerializableFunction doubleTransform = Transforms.truncate(this.truncateLength).bind(Types.DoubleType.get());
                this.evaluator = arg -> {
                    DoubleWritable val = (DoubleWritable)this.converter.convert(arg.get());
                    this.result.set(String.valueOf(doubleTransform.apply(val.get())));
                };
                break;
            }
            default: {
                throw new UDFArgumentException(" ICEBERG_TRUNCATE() only takes STRING/CHAR/VARCHAR/INT/LONG/DECIMAL/FLOAT/DOUBLE types as first argument, got " + inputType);
            }
        }
        WritableStringObjectInspector outputOI = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        return outputOI;
    }

    private static int getTruncateLength(ObjectInspector arg) throws UDFArgumentException {
        UDFArgumentException udfArgumentException = new UDFArgumentException("ICEBERG_TRUNCATE() second argument can  only take an int type, but got " + arg.getTypeName());
        if (arg.getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw udfArgumentException;
        }
        PrimitiveObjectInspector.PrimitiveCategory inputType = ((PrimitiveObjectInspector)arg).getPrimitiveCategory();
        if (inputType != PrimitiveObjectInspector.PrimitiveCategory.INT) {
            throw udfArgumentException;
        }
        return ((WritableConstantIntObjectInspector)arg).getWritableConstantValue().get();
    }

    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        GenericUDF.DeferredObject argument = arguments[0];
        if (argument == null || argument.get() == null) {
            return null;
        }
        this.evaluator.apply(argument);
        return this.result;
    }

    public String getDisplayString(String[] children) {
        return this.getStandardDisplayString("iceberg_truncate", children);
    }

    @FunctionalInterface
    private static interface UDFEvalFunction<T> {
        public void apply(T var1) throws HiveException;
    }
}

