/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data;

import java.io.IOException;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.data.GenericReader;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.io.CloseableGroup;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;

class TableScanIterable
extends CloseableGroup
implements CloseableIterable<Record> {
    private final GenericReader reader;
    private final CloseableIterable<CombinedScanTask> tasks;

    TableScanIterable(TableScan scan, boolean reuseContainers) {
        this.reader = new GenericReader(scan, reuseContainers);
        this.tasks = scan.planTasks();
    }

    @Override
    public CloseableIterator<Record> iterator() {
        CloseableIterator<Record> iter = this.reader.open(this.tasks);
        this.addCloseable(iter);
        return iter;
    }

    @Override
    public void close() throws IOException {
        this.tasks.close();
        super.close();
    }
}

