/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.MergeableScanTask;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PositionDeletesScanTask;
import org.apache.iceberg.ScanTask;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;

class SplitPositionDeletesScanTask
implements PositionDeletesScanTask,
MergeableScanTask<PositionDeletesScanTask> {
    private final PositionDeletesScanTask parentTask;
    private final long offset;
    private final long length;

    protected SplitPositionDeletesScanTask(PositionDeletesScanTask parentTask, long offset, long length) {
        this.parentTask = parentTask;
        this.offset = offset;
        this.length = length;
    }

    @Override
    public DeleteFile file() {
        return (DeleteFile)this.parentTask.file();
    }

    @Override
    public PartitionSpec spec() {
        return this.parentTask.spec();
    }

    @Override
    public long start() {
        return this.offset;
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public Expression residual() {
        return this.parentTask.residual();
    }

    @Override
    public boolean canMerge(ScanTask other) {
        if (other instanceof SplitPositionDeletesScanTask) {
            SplitPositionDeletesScanTask that = (SplitPositionDeletesScanTask)other;
            return this.file().equals(that.file()) && this.offset + this.length == that.start();
        }
        return false;
    }

    @Override
    public SplitPositionDeletesScanTask merge(ScanTask other) {
        SplitPositionDeletesScanTask that = (SplitPositionDeletesScanTask)other;
        return new SplitPositionDeletesScanTask(this.parentTask, this.offset, this.length + that.length());
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("file", this.file().location()).add("partition_data", this.file().partition()).add("offset", this.offset).add("length", this.length).add("residual", this.residual()).toString();
    }
}

