/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store;

import java.util.Map;
import java.util.Properties;
import org.datanucleus.ExecutionContext;
import org.datanucleus.metadata.SequenceMetaData;
import org.datanucleus.store.NucleusSequence;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.valuegenerator.ValueGenerationConnectionProvider;
import org.datanucleus.store.valuegenerator.ValueGenerationManager;
import org.datanucleus.store.valuegenerator.ValueGenerator;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class NucleusSequenceImpl
implements NucleusSequence {
    protected final StoreManager storeManager;
    protected final SequenceMetaData seqMetaData;
    protected ValueGenerator generator;
    protected final ExecutionContext ec;

    public NucleusSequenceImpl(ExecutionContext objectMgr, StoreManager storeMgr, SequenceMetaData seqmd) {
        this.ec = objectMgr;
        this.storeManager = storeMgr;
        this.seqMetaData = seqmd;
        this.setGenerator();
    }

    protected void setGenerator() {
        String valueGeneratorName = "sequence";
        Properties props = new Properties();
        Map<String, String> seqExtensions = this.seqMetaData.getExtensions();
        if (seqExtensions != null && seqExtensions.size() > 0) {
            props.putAll(seqExtensions);
        }
        props.put("sequence-name", this.seqMetaData.getDatastoreSequence());
        if (this.seqMetaData.getAllocationSize() > 0) {
            props.put("key-cache-size", "" + this.seqMetaData.getAllocationSize());
        }
        if (this.seqMetaData.getInitialValue() > 0) {
            props.put("key-initial-value", "" + this.seqMetaData.getInitialValue());
        }
        ValueGenerationManager mgr = this.storeManager.getValueGenerationManager();
        ValueGenerationConnectionProvider connProvider = new ValueGenerationConnectionProvider(){
            ManagedConnection mconn;

            @Override
            public ManagedConnection retrieveConnection() {
                this.mconn = NucleusSequenceImpl.this.storeManager.getConnectionManager().getConnection(NucleusSequenceImpl.this.ec);
                return this.mconn;
            }

            @Override
            public void releaseConnection() {
                this.mconn.release();
                this.mconn = null;
            }
        };
        this.generator = mgr.createValueGenerator(valueGeneratorName, this.seqMetaData.getName(), props, connProvider);
        if (NucleusLogger.DATASTORE.isDebugEnabled()) {
            NucleusLogger.DATASTORE.debug(Localiser.msg("017003", this.seqMetaData.getName(), valueGeneratorName));
        }
    }

    @Override
    public String getName() {
        return this.seqMetaData.getName();
    }

    @Override
    public void allocate(int additional) {
        this.generator.allocate(additional);
    }

    @Override
    public Object next() {
        return this.generator.next();
    }

    @Override
    public long nextValue() {
        return this.generator.nextValue();
    }

    @Override
    public Object current() {
        return this.generator.current();
    }

    @Override
    public long currentValue() {
        return this.generator.currentValue();
    }
}

