/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.table;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.TableImpl;
import org.datanucleus.store.schema.naming.NamingCase;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class ProbeTable
extends TableImpl {
    public ProbeTable(RDBMSStoreManager storeMgr) {
        super(storeMgr.getIdentifierFactory().newTableIdentifier("DELETEME" + System.currentTimeMillis()), storeMgr);
    }

    @Override
    public void initialize(ClassLoaderResolver clr) {
        this.assertIsUninitialized();
        JavaTypeMapping mapping = this.storeMgr.getMappingManager().getMapping(Integer.TYPE);
        Column column = this.addColumn(Integer.TYPE.getName(), this.storeMgr.getIdentifierFactory().newColumnIdentifier("UNUSED"), mapping, null);
        this.storeMgr.getMappingManager().createColumnMapping(mapping, column, Integer.TYPE.getName());
        this.state = (short)2;
    }

    @Override
    public JavaTypeMapping getIdMapping() {
        throw new NucleusException("Attempt to get ID mapping of ProbeTable!").setFatal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] findSchemaDetails(Connection conn) throws SQLException {
        String[] schemaDetails = new String[2];
        DatabaseMetaData dmd = conn.getMetaData();
        String table_name = this.identifier.getName();
        if (this.storeMgr.getIdentifierFactory().getNamingCase() == NamingCase.LOWER_CASE || this.storeMgr.getIdentifierFactory().getNamingCase() == NamingCase.LOWER_CASE_QUOTED) {
            table_name = table_name.toLowerCase();
        } else if (this.storeMgr.getIdentifierFactory().getNamingCase() == NamingCase.UPPER_CASE || this.storeMgr.getIdentifierFactory().getNamingCase() == NamingCase.UPPER_CASE_QUOTED) {
            table_name = table_name.toUpperCase();
        }
        String catalog_name = this.storeMgr.getStringProperty("datanucleus.mapping.catalog");
        String schema_name = this.storeMgr.getStringProperty("datanucleus.mapping.schema");
        if (!this.dba.supportsOption("CatalogInTableDefinition")) {
            catalog_name = null;
        }
        if (!this.dba.supportsOption("SchemaInTableDefinition")) {
            schema_name = null;
        }
        try (ResultSet rs = dmd.getTables(catalog_name, schema_name, table_name, null);){
            if (!rs.next()) {
                throw new NucleusDataStoreException(Localiser.msg((String)"057027", (Object[])new Object[]{this.identifier}));
            }
            schemaDetails[0] = rs.getString(1);
            schemaDetails[1] = rs.getString(2);
        }
        if (schemaDetails[0] == null) {
            NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"057026"));
        }
        if (schemaDetails[1] == null) {
            NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"057025"));
        }
        return schemaDetails;
    }

    @Override
    protected boolean allowDDLOutput() {
        return false;
    }

    @Override
    public JavaTypeMapping getMemberMapping(AbstractMemberMetaData mmd) {
        return null;
    }
}

