/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest;

import com.codahale.metrics.Counter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.metastore.metrics.Metrics;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.BaseTransaction;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.Transactions;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.SupportsNamespaces;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.catalog.ViewCatalog;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.CommitStateUnknownException;
import org.apache.iceberg.exceptions.ForbiddenException;
import org.apache.iceberg.exceptions.NamespaceNotEmptyException;
import org.apache.iceberg.exceptions.NoSuchIcebergTableException;
import org.apache.iceberg.exceptions.NoSuchNamespaceException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.exceptions.NotAuthorizedException;
import org.apache.iceberg.exceptions.RESTException;
import org.apache.iceberg.exceptions.UnprocessableEntityException;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.relocated.com.google.common.base.Splitter;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.rest.CatalogHandlers;
import org.apache.iceberg.rest.RESTClient;
import org.apache.iceberg.rest.RESTRequest;
import org.apache.iceberg.rest.RESTResponse;
import org.apache.iceberg.rest.RESTUtil;
import org.apache.iceberg.rest.requests.CommitTransactionRequest;
import org.apache.iceberg.rest.requests.CreateNamespaceRequest;
import org.apache.iceberg.rest.requests.CreateTableRequest;
import org.apache.iceberg.rest.requests.CreateViewRequest;
import org.apache.iceberg.rest.requests.RegisterTableRequest;
import org.apache.iceberg.rest.requests.RenameTableRequest;
import org.apache.iceberg.rest.requests.ReportMetricsRequest;
import org.apache.iceberg.rest.requests.UpdateNamespacePropertiesRequest;
import org.apache.iceberg.rest.requests.UpdateTableRequest;
import org.apache.iceberg.rest.responses.ConfigResponse;
import org.apache.iceberg.rest.responses.CreateNamespaceResponse;
import org.apache.iceberg.rest.responses.ErrorResponse;
import org.apache.iceberg.rest.responses.GetNamespaceResponse;
import org.apache.iceberg.rest.responses.ListNamespacesResponse;
import org.apache.iceberg.rest.responses.ListTablesResponse;
import org.apache.iceberg.rest.responses.LoadTableResponse;
import org.apache.iceberg.rest.responses.LoadViewResponse;
import org.apache.iceberg.rest.responses.OAuthTokenResponse;
import org.apache.iceberg.rest.responses.UpdateNamespacePropertiesResponse;
import org.apache.iceberg.util.Pair;
import org.apache.iceberg.util.PropertyUtil;

public class HMSCatalogAdapter
implements RESTClient {
    static final String HMS_METRIC_PREFIX = "hmscatalog.";
    private static final Splitter SLASH = Splitter.on((char)'/');
    private static final Map<Class<? extends Exception>, Integer> EXCEPTION_ERROR_CODES = ImmutableMap.builder().put(NamespaceNotSupported.class, (Object)400).put(IllegalArgumentException.class, (Object)400).put(ValidationException.class, (Object)400).put(NamespaceNotEmptyException.class, (Object)400).put(NotAuthorizedException.class, (Object)401).put(ForbiddenException.class, (Object)403).put(NoSuchNamespaceException.class, (Object)404).put(NoSuchTableException.class, (Object)404).put(NoSuchIcebergTableException.class, (Object)404).put(UnsupportedOperationException.class, (Object)406).put(AlreadyExistsException.class, (Object)409).put(CommitFailedException.class, (Object)409).put(UnprocessableEntityException.class, (Object)422).put(CommitStateUnknownException.class, (Object)500).buildOrThrow();
    private static final String URN_OAUTH_TOKEN_EXCHANGE = "urn:ietf:params:oauth:grant-type:token-exchange";
    private static final String URN_OAUTH_ACCESS_TOKEN = "urn:ietf:params:oauth:token-type:access_token";
    private static final String GRANT_TYPE = "grant_type";
    private static final String CLIENT_CREDENTIALS = "client_credentials";
    private static final String BEARER = "Bearer";
    private static final String CLIENT_ID = "client_id";
    private static final String ACTOR_TOKEN = "actor_token";
    private static final String SUBJECT_TOKEN = "subject_token";
    private static final String VIEWS_PATH = "v1/namespaces/{namespace}/views/{name}";
    private static final String TABLES_PATH = "v1/namespaces/{namespace}/tables/{table}";
    private final Catalog catalog;
    private final SupportsNamespaces asNamespaceCatalog;
    private final ViewCatalog asViewCatalog;

    public HMSCatalogAdapter(Catalog catalog) {
        this.catalog = catalog;
        this.asNamespaceCatalog = catalog instanceof SupportsNamespaces ? (SupportsNamespaces)catalog : null;
        this.asViewCatalog = catalog instanceof ViewCatalog ? (ViewCatalog)catalog : null;
    }

    static String hmsCatalogMetricCount(String route) {
        return HMS_METRIC_PREFIX + route.toLowerCase() + ".count";
    }

    public static List<String> getMetricNames(String ... apis) {
        List<Route> routes = apis != null && apis.length > 0 ? Arrays.stream(apis).map(Route::byName).filter(Objects::nonNull).collect(Collectors.toList()) : Arrays.asList(Route.values());
        ArrayList<String> metricNames = new ArrayList<String>(routes.size());
        for (Route route : routes) {
            metricNames.add(HMSCatalogAdapter.hmsCatalogMetricCount(route.name()));
        }
        return metricNames;
    }

    private ConfigResponse config() {
        return HMSCatalogAdapter.castResponse(ConfigResponse.class, ConfigResponse.builder().build());
    }

    private OAuthTokenResponse tokens(Object body) {
        String grantType;
        Map request = HMSCatalogAdapter.castRequest(Map.class, body);
        switch (grantType = (String)request.get(GRANT_TYPE)) {
            case "client_credentials": {
                return OAuthTokenResponse.builder().withToken("client-credentials-token:sub=" + (String)request.get(CLIENT_ID)).withIssuedTokenType(URN_OAUTH_ACCESS_TOKEN).withTokenType(BEARER).build();
            }
            case "urn:ietf:params:oauth:grant-type:token-exchange": {
                String actor = (String)request.get(ACTOR_TOKEN);
                String token = String.format("token-exchange-token:sub=%s%s", request.get(SUBJECT_TOKEN), actor != null ? ",act=" + actor : "");
                return OAuthTokenResponse.builder().withToken(token).withIssuedTokenType(URN_OAUTH_ACCESS_TOKEN).withTokenType(BEARER).build();
            }
        }
        throw new UnsupportedOperationException("Unsupported grant_type: " + grantType);
    }

    private ListNamespacesResponse listNamespaces(Map<String, String> vars) {
        if (this.asNamespaceCatalog != null) {
            Namespace namespace = vars.containsKey("parent") ? Namespace.of((String[])((String[])RESTUtil.NAMESPACE_SPLITTER.splitToStream((CharSequence)vars.get("parent")).toArray(String[]::new))) : Namespace.empty();
            return HMSCatalogAdapter.castResponse(ListNamespacesResponse.class, CatalogHandlers.listNamespaces((SupportsNamespaces)this.asNamespaceCatalog, (Namespace)namespace));
        }
        throw new NamespaceNotSupported(this.catalog.toString());
    }

    private CreateNamespaceResponse createNamespace(Object body) {
        if (this.asNamespaceCatalog != null) {
            CreateNamespaceRequest request = HMSCatalogAdapter.castRequest(CreateNamespaceRequest.class, body);
            return HMSCatalogAdapter.castResponse(CreateNamespaceResponse.class, CatalogHandlers.createNamespace((SupportsNamespaces)this.asNamespaceCatalog, (CreateNamespaceRequest)request));
        }
        throw new NamespaceNotSupported(this.catalog.toString());
    }

    private GetNamespaceResponse loadNamespace(Map<String, String> vars) {
        if (this.asNamespaceCatalog != null) {
            Namespace namespace = HMSCatalogAdapter.namespaceFromPathVars(vars);
            return HMSCatalogAdapter.castResponse(GetNamespaceResponse.class, CatalogHandlers.loadNamespace((SupportsNamespaces)this.asNamespaceCatalog, (Namespace)namespace));
        }
        throw new NamespaceNotSupported(this.catalog.toString());
    }

    private RESTResponse dropNamespace(Map<String, String> vars) {
        if (this.asNamespaceCatalog != null) {
            CatalogHandlers.dropNamespace((SupportsNamespaces)this.asNamespaceCatalog, (Namespace)HMSCatalogAdapter.namespaceFromPathVars(vars));
            return null;
        }
        throw new NamespaceNotSupported(this.catalog.toString());
    }

    private UpdateNamespacePropertiesResponse updateNamespace(Map<String, String> vars, Object body) {
        if (this.asNamespaceCatalog != null) {
            Namespace namespace = HMSCatalogAdapter.namespaceFromPathVars(vars);
            UpdateNamespacePropertiesRequest request = HMSCatalogAdapter.castRequest(UpdateNamespacePropertiesRequest.class, body);
            return HMSCatalogAdapter.castResponse(UpdateNamespacePropertiesResponse.class, CatalogHandlers.updateNamespaceProperties((SupportsNamespaces)this.asNamespaceCatalog, (Namespace)namespace, (UpdateNamespacePropertiesRequest)request));
        }
        throw new NamespaceNotSupported(this.catalog.toString());
    }

    private ListTablesResponse listTables(Map<String, String> vars) {
        Namespace namespace = HMSCatalogAdapter.namespaceFromPathVars(vars);
        return HMSCatalogAdapter.castResponse(ListTablesResponse.class, CatalogHandlers.listTables((Catalog)this.catalog, (Namespace)namespace));
    }

    private LoadTableResponse createTable(Map<String, String> vars, Object body) {
        Class<LoadTableResponse> responseType = LoadTableResponse.class;
        Namespace namespace = HMSCatalogAdapter.namespaceFromPathVars(vars);
        CreateTableRequest request = HMSCatalogAdapter.castRequest(CreateTableRequest.class, body);
        request.validate();
        if (request.stageCreate()) {
            return HMSCatalogAdapter.castResponse(responseType, CatalogHandlers.stageTableCreate((Catalog)this.catalog, (Namespace)namespace, (CreateTableRequest)request));
        }
        return HMSCatalogAdapter.castResponse(responseType, CatalogHandlers.createTable((Catalog)this.catalog, (Namespace)namespace, (CreateTableRequest)request));
    }

    private RESTResponse dropTable(Map<String, String> vars) {
        if (PropertyUtil.propertyAsBoolean(vars, (String)"purgeRequested", (boolean)false)) {
            CatalogHandlers.purgeTable((Catalog)this.catalog, (TableIdentifier)HMSCatalogAdapter.identFromPathVars(vars));
        } else {
            CatalogHandlers.dropTable((Catalog)this.catalog, (TableIdentifier)HMSCatalogAdapter.identFromPathVars(vars));
        }
        return null;
    }

    private LoadTableResponse loadTable(Map<String, String> vars) {
        TableIdentifier ident = HMSCatalogAdapter.identFromPathVars(vars);
        return HMSCatalogAdapter.castResponse(LoadTableResponse.class, CatalogHandlers.loadTable((Catalog)this.catalog, (TableIdentifier)ident));
    }

    private LoadTableResponse registerTable(Map<String, String> vars, Object body) {
        Namespace namespace = HMSCatalogAdapter.namespaceFromPathVars(vars);
        RegisterTableRequest request = HMSCatalogAdapter.castRequest(RegisterTableRequest.class, body);
        return HMSCatalogAdapter.castResponse(LoadTableResponse.class, CatalogHandlers.registerTable((Catalog)this.catalog, (Namespace)namespace, (RegisterTableRequest)request));
    }

    private LoadTableResponse updateTable(Map<String, String> vars, Object body) {
        TableIdentifier ident = HMSCatalogAdapter.identFromPathVars(vars);
        UpdateTableRequest request = HMSCatalogAdapter.castRequest(UpdateTableRequest.class, body);
        return HMSCatalogAdapter.castResponse(LoadTableResponse.class, CatalogHandlers.updateTable((Catalog)this.catalog, (TableIdentifier)ident, (UpdateTableRequest)request));
    }

    private RESTResponse renameTable(Object body) {
        RenameTableRequest request = HMSCatalogAdapter.castRequest(RenameTableRequest.class, body);
        CatalogHandlers.renameTable((Catalog)this.catalog, (RenameTableRequest)request);
        return null;
    }

    private RESTResponse reportMetrics(Object body) {
        HMSCatalogAdapter.castRequest(ReportMetricsRequest.class, body);
        return null;
    }

    private RESTResponse commitTransaction(Object body) {
        CommitTransactionRequest request = HMSCatalogAdapter.castRequest(CommitTransactionRequest.class, body);
        HMSCatalogAdapter.commitTransaction(this.catalog, request);
        return null;
    }

    private ListTablesResponse listViews(Map<String, String> vars) {
        if (null != this.asViewCatalog) {
            Namespace namespace = HMSCatalogAdapter.namespaceFromPathVars(vars);
            String pageToken = PropertyUtil.propertyAsString(vars, (String)"pageToken", null);
            String pageSize = PropertyUtil.propertyAsString(vars, (String)"pageSize", null);
            if (pageSize != null) {
                return HMSCatalogAdapter.castResponse(ListTablesResponse.class, CatalogHandlers.listViews((ViewCatalog)this.asViewCatalog, (Namespace)namespace, (String)pageToken, (String)pageSize));
            }
            return HMSCatalogAdapter.castResponse(ListTablesResponse.class, CatalogHandlers.listViews((ViewCatalog)this.asViewCatalog, (Namespace)namespace));
        }
        throw new ViewNotSupported(this.catalog.toString());
    }

    private LoadViewResponse createView(Map<String, String> vars, Object body) {
        if (null != this.asViewCatalog) {
            Namespace namespace = HMSCatalogAdapter.namespaceFromPathVars(vars);
            CreateViewRequest request = HMSCatalogAdapter.castRequest(CreateViewRequest.class, body);
            return HMSCatalogAdapter.castResponse(LoadViewResponse.class, CatalogHandlers.createView((ViewCatalog)this.asViewCatalog, (Namespace)namespace, (CreateViewRequest)request));
        }
        throw new ViewNotSupported(this.catalog.toString());
    }

    private LoadViewResponse loadView(Map<String, String> vars) {
        if (null != this.asViewCatalog) {
            TableIdentifier ident = HMSCatalogAdapter.identFromPathVars(vars);
            return HMSCatalogAdapter.castResponse(LoadViewResponse.class, CatalogHandlers.loadView((ViewCatalog)this.asViewCatalog, (TableIdentifier)ident));
        }
        throw new ViewNotSupported(this.catalog.toString());
    }

    private LoadViewResponse updateView(Map<String, String> vars, Object body) {
        if (null != this.asViewCatalog) {
            TableIdentifier ident = HMSCatalogAdapter.identFromPathVars(vars);
            UpdateTableRequest request = HMSCatalogAdapter.castRequest(UpdateTableRequest.class, body);
            return HMSCatalogAdapter.castResponse(LoadViewResponse.class, CatalogHandlers.updateView((ViewCatalog)this.asViewCatalog, (TableIdentifier)ident, (UpdateTableRequest)request));
        }
        throw new ViewNotSupported(this.catalog.toString());
    }

    private RESTResponse renameView(Object body) {
        if (null != this.asViewCatalog) {
            RenameTableRequest request = HMSCatalogAdapter.castRequest(RenameTableRequest.class, body);
            CatalogHandlers.renameView((ViewCatalog)this.asViewCatalog, (RenameTableRequest)request);
            return null;
        }
        throw new ViewNotSupported(this.catalog.toString());
    }

    private RESTResponse dropView(Map<String, String> vars) {
        if (null != this.asViewCatalog) {
            CatalogHandlers.dropView((ViewCatalog)this.asViewCatalog, (TableIdentifier)HMSCatalogAdapter.identFromPathVars(vars));
            return null;
        }
        throw new ViewNotSupported(this.catalog.toString());
    }

    private static void commitTransaction(Catalog catalog, CommitTransactionRequest request) {
        ArrayList transactions = Lists.newArrayList();
        for (UpdateTableRequest tableChange : request.tableChanges()) {
            Table table = catalog.loadTable(tableChange.identifier());
            if (table instanceof BaseTable) {
                Transaction transaction = Transactions.newTransaction((String)tableChange.identifier().toString(), (TableOperations)((BaseTable)table).operations());
                transactions.add(transaction);
                BaseTransaction.TransactionTable txTable = (BaseTransaction.TransactionTable)transaction.table();
                CatalogHandlers.commit((TableOperations)txTable.operations(), (UpdateTableRequest)tableChange);
                continue;
            }
            throw new IllegalStateException("Cannot wrap catalog that does not produce BaseTable");
        }
        transactions.forEach(Transaction::commitTransaction);
    }

    private <T extends RESTResponse> T handleRequest(Route route, Map<String, String> vars, Object body) {
        String metricName = HMSCatalogAdapter.hmsCatalogMetricCount(route.name());
        Counter counter = Metrics.getOrCreateCounter((String)metricName);
        if (counter != null) {
            counter.inc();
        }
        switch (route) {
            case TOKENS: {
                return (T)this.tokens(body);
            }
            case CONFIG: {
                return (T)this.config();
            }
            case LIST_NAMESPACES: {
                return (T)this.listNamespaces(vars);
            }
            case CREATE_NAMESPACE: {
                return (T)this.createNamespace(body);
            }
            case LOAD_NAMESPACE: {
                return (T)this.loadNamespace(vars);
            }
            case DROP_NAMESPACE: {
                return (T)this.dropNamespace(vars);
            }
            case UPDATE_NAMESPACE: {
                return (T)this.updateNamespace(vars, body);
            }
            case LIST_TABLES: {
                return (T)this.listTables(vars);
            }
            case CREATE_TABLE: {
                return (T)this.createTable(vars, body);
            }
            case DROP_TABLE: {
                return (T)this.dropTable(vars);
            }
            case LOAD_TABLE: {
                return (T)this.loadTable(vars);
            }
            case REGISTER_TABLE: {
                return (T)this.registerTable(vars, body);
            }
            case UPDATE_TABLE: {
                return (T)this.updateTable(vars, body);
            }
            case RENAME_TABLE: {
                return (T)this.renameTable(body);
            }
            case REPORT_METRICS: {
                return (T)this.reportMetrics(body);
            }
            case COMMIT_TRANSACTION: {
                return (T)this.commitTransaction(body);
            }
            case LIST_VIEWS: {
                return (T)this.listViews(vars);
            }
            case CREATE_VIEW: {
                return (T)this.createView(vars, body);
            }
            case LOAD_VIEW: {
                return (T)this.loadView(vars);
            }
            case UPDATE_VIEW: {
                return (T)this.updateView(vars, body);
            }
            case RENAME_VIEW: {
                return (T)this.renameView(vars);
            }
            case DROP_VIEW: {
                return (T)this.dropView(vars);
            }
        }
        return null;
    }

    <T extends RESTResponse> T execute(HTTPMethod method, String path, Map<String, String> queryParams, Object body, Class<T> responseType, Map<String, String> headers, Consumer<ErrorResponse> errorHandler) {
        ErrorResponse.Builder errorBuilder = ErrorResponse.builder();
        Pair<Route, Map<String, String>> routeAndVars = Route.from(method, path);
        if (routeAndVars != null) {
            try {
                ImmutableMap.Builder vars = ImmutableMap.builder();
                if (queryParams != null) {
                    vars.putAll(queryParams);
                }
                vars.putAll((Map)routeAndVars.second());
                return this.handleRequest((Route)((Object)routeAndVars.first()), (Map<String, String>)vars.build(), body);
            }
            catch (RuntimeException e) {
                HMSCatalogAdapter.configureResponseFromException(e, errorBuilder);
            }
        } else {
            errorBuilder.responseCode(Integer.valueOf(400)).withType("BadRequestException").withMessage(String.format("No route for request: %s %s", new Object[]{method, path}));
        }
        ErrorResponse error = errorBuilder.build();
        errorHandler.accept(error);
        throw new RESTException("Unhandled error: %s", new Object[]{error});
    }

    public <T extends RESTResponse> T delete(String path, Class<T> responseType, Map<String, String> headers, Consumer<ErrorResponse> errorHandler) {
        return this.execute(HTTPMethod.DELETE, path, null, null, responseType, headers, errorHandler);
    }

    public <T extends RESTResponse> T delete(String path, Map<String, String> queryParams, Class<T> responseType, Map<String, String> headers, Consumer<ErrorResponse> errorHandler) {
        return this.execute(HTTPMethod.DELETE, path, queryParams, null, responseType, headers, errorHandler);
    }

    public <T extends RESTResponse> T post(String path, RESTRequest body, Class<T> responseType, Map<String, String> headers, Consumer<ErrorResponse> errorHandler) {
        return this.execute(HTTPMethod.POST, path, null, body, responseType, headers, errorHandler);
    }

    public <T extends RESTResponse> T get(String path, Map<String, String> queryParams, Class<T> responseType, Map<String, String> headers, Consumer<ErrorResponse> errorHandler) {
        return this.execute(HTTPMethod.GET, path, queryParams, null, responseType, headers, errorHandler);
    }

    public void head(String path, Map<String, String> headers, Consumer<ErrorResponse> errorHandler) {
        this.execute(HTTPMethod.HEAD, path, null, null, null, headers, errorHandler);
    }

    public <T extends RESTResponse> T postForm(String path, Map<String, String> formData, Class<T> responseType, Map<String, String> headers, Consumer<ErrorResponse> errorHandler) {
        return this.execute(HTTPMethod.POST, path, null, formData, responseType, headers, errorHandler);
    }

    public void close() {
    }

    public static <T> T castRequest(Class<T> requestType, Object request) {
        if (requestType.isInstance(request)) {
            return requestType.cast(request);
        }
        throw new BadRequestType(requestType, request);
    }

    public static <T extends RESTResponse> T castResponse(Class<T> responseType, Object response) {
        if (responseType.isInstance(response)) {
            return (T)((RESTResponse)responseType.cast(response));
        }
        throw new BadResponseType(responseType, response);
    }

    public static void configureResponseFromException(Exception exc, ErrorResponse.Builder errorBuilder) {
        errorBuilder.responseCode(EXCEPTION_ERROR_CODES.getOrDefault(exc.getClass(), 500)).withType(exc.getClass().getSimpleName()).withMessage(exc.getMessage()).withStackTrace((Throwable)exc);
    }

    private static Namespace namespaceFromPathVars(Map<String, String> pathVars) {
        return RESTUtil.decodeNamespace((String)pathVars.get("namespace"));
    }

    private static TableIdentifier identFromPathVars(Map<String, String> pathVars) {
        return TableIdentifier.of((Namespace)HMSCatalogAdapter.namespaceFromPathVars(pathVars), (String)RESTUtil.decodeString((String)pathVars.get("table")));
    }

    static enum Route {
        TOKENS(HTTPMethod.POST, "v1/oauth/tokens", null, OAuthTokenResponse.class),
        SEPARATE_AUTH_TOKENS_URI(HTTPMethod.POST, "https://auth-server.com/token", null, OAuthTokenResponse.class),
        CONFIG(HTTPMethod.GET, "v1/config", null, ConfigResponse.class),
        LIST_NAMESPACES(HTTPMethod.GET, "v1/namespaces", null, ListNamespacesResponse.class),
        CREATE_NAMESPACE(HTTPMethod.POST, "v1/namespaces", CreateNamespaceRequest.class, CreateNamespaceResponse.class),
        LOAD_NAMESPACE(HTTPMethod.GET, "v1/namespaces/{namespace}", null, GetNamespaceResponse.class),
        DROP_NAMESPACE(HTTPMethod.DELETE, "v1/namespaces/{namespace}"),
        UPDATE_NAMESPACE(HTTPMethod.POST, "v1/namespaces/{namespace}/properties", UpdateNamespacePropertiesRequest.class, UpdateNamespacePropertiesResponse.class),
        LIST_TABLES(HTTPMethod.GET, "v1/namespaces/{namespace}/tables", null, ListTablesResponse.class),
        CREATE_TABLE(HTTPMethod.POST, "v1/namespaces/{namespace}/tables", CreateTableRequest.class, LoadTableResponse.class),
        LOAD_TABLE(HTTPMethod.GET, "v1/namespaces/{namespace}/tables/{table}", null, LoadTableResponse.class),
        REGISTER_TABLE(HTTPMethod.POST, "v1/namespaces/{namespace}/register", RegisterTableRequest.class, LoadTableResponse.class),
        UPDATE_TABLE(HTTPMethod.POST, "v1/namespaces/{namespace}/tables/{table}", UpdateTableRequest.class, LoadTableResponse.class),
        DROP_TABLE(HTTPMethod.DELETE, "v1/namespaces/{namespace}/tables/{table}"),
        RENAME_TABLE(HTTPMethod.POST, "v1/tables/rename", RenameTableRequest.class, null),
        REPORT_METRICS(HTTPMethod.POST, "v1/namespaces/{namespace}/tables/{table}/metrics", ReportMetricsRequest.class, null),
        COMMIT_TRANSACTION(HTTPMethod.POST, "v1/transactions/commit", CommitTransactionRequest.class, null),
        LIST_VIEWS(HTTPMethod.GET, "v1/namespaces/{namespace}/views", null, ListTablesResponse.class),
        LOAD_VIEW(HTTPMethod.GET, "v1/namespaces/{namespace}/views/{name}", null, LoadViewResponse.class),
        CREATE_VIEW(HTTPMethod.POST, "v1/namespaces/{namespace}/views", CreateViewRequest.class, LoadViewResponse.class),
        UPDATE_VIEW(HTTPMethod.POST, "v1/namespaces/{namespace}/views/{name}", UpdateTableRequest.class, LoadViewResponse.class),
        RENAME_VIEW(HTTPMethod.POST, "v1/views/rename", RenameTableRequest.class, null),
        DROP_VIEW(HTTPMethod.DELETE, "v1/namespaces/{namespace}/views/{name}");

        private final HTTPMethod method;
        private final int requiredLength;
        private final Map<Integer, String> requirements;
        private final Map<Integer, String> variables;
        private final Class<? extends RESTRequest> requestClass;
        private final Class<? extends RESTResponse> responseClass;

        static Route byName(String name) {
            try {
                return Route.valueOf(name.toUpperCase());
            }
            catch (IllegalArgumentException xill) {
                return null;
            }
        }

        private Route(HTTPMethod method, String pattern) {
            this(method, pattern, null, null);
        }

        private Route(HTTPMethod method, String pattern, Class<? extends RESTRequest> requestClass, Class<? extends RESTResponse> responseClass) {
            this.method = method;
            List parts = SLASH.splitToList((CharSequence)pattern);
            ImmutableMap.Builder requirementsBuilder = ImmutableMap.builder();
            ImmutableMap.Builder variablesBuilder = ImmutableMap.builder();
            for (int pos = 0; pos < parts.size(); ++pos) {
                String part = (String)parts.get(pos);
                if (part.startsWith("{") && part.endsWith("}")) {
                    variablesBuilder.put((Object)pos, (Object)part.substring(1, part.length() - 1));
                    continue;
                }
                requirementsBuilder.put((Object)pos, (Object)part);
            }
            this.requestClass = requestClass;
            this.responseClass = responseClass;
            this.requiredLength = parts.size();
            this.requirements = requirementsBuilder.build();
            this.variables = variablesBuilder.build();
        }

        private boolean matches(HTTPMethod requestMethod, List<String> requestPath) {
            return this.method == requestMethod && this.requiredLength == requestPath.size() && this.requirements.entrySet().stream().allMatch(requirement -> ((String)requirement.getValue()).equalsIgnoreCase((String)requestPath.get((Integer)requirement.getKey())));
        }

        private Map<String, String> variables(List<String> requestPath) {
            ImmutableMap.Builder vars = ImmutableMap.builder();
            this.variables.forEach((key, value) -> vars.put(value, (Object)((String)requestPath.get((int)key))));
            return vars.build();
        }

        public static Pair<Route, Map<String, String>> from(HTTPMethod method, String path) {
            List parts = SLASH.splitToList((CharSequence)path);
            for (Route candidate : Route.values()) {
                if (!candidate.matches(method, parts)) continue;
                return Pair.of((Object)((Object)candidate), candidate.variables(parts));
            }
            return null;
        }

        public Class<? extends RESTRequest> requestClass() {
            return this.requestClass;
        }

        public Class<? extends RESTResponse> responseClass() {
            return this.responseClass;
        }
    }

    private static class NamespaceNotSupported
    extends RuntimeException {
        NamespaceNotSupported(String catalog) {
            super("catalog " + catalog + " does not support namespace");
        }
    }

    private static class ViewNotSupported
    extends RuntimeException {
        ViewNotSupported(String catalog) {
            super("catalog " + catalog + " does not support views");
        }
    }

    static enum HTTPMethod {
        GET,
        HEAD,
        POST,
        DELETE;

    }

    private static class BadRequestType
    extends RuntimeException {
        private BadRequestType(Class<?> requestType, Object request) {
            super(String.format("Invalid request object, not a %s: %s", requestType.getName(), request));
        }
    }

    private static class BadResponseType
    extends RuntimeException {
        private BadResponseType(Class<?> responseType, Object response) {
            super(String.format("Invalid response object, not a %s: %s", responseType.getName(), response));
        }
    }
}

