/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractTransformer;
import org.apache.hadoop.hive.ql.udf.generic.AbstractTransformerAdapter;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.io.Text;

class StringTransformerAdapter
extends AbstractTransformerAdapter {
    final StringObjectInspector columnType;
    final Text writable;

    public StringTransformerAdapter(StringObjectInspector columnType, AbstractTransformer transformer) {
        this(columnType, transformer, new Text());
    }

    public StringTransformerAdapter(StringObjectInspector columnType, AbstractTransformer transformer, Text writable) {
        super(transformer);
        this.columnType = columnType;
        this.writable = writable;
    }

    @Override
    public Object getTransformedWritable(GenericUDF.DeferredObject object) throws HiveException {
        String transformedValue;
        String value = this.columnType.getPrimitiveJavaObject(object.get());
        if (value != null && (transformedValue = this.transformer.transform(value)) != null) {
            this.writable.set(transformedValue);
            return this.writable;
        }
        return null;
    }
}

