/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.esri;

import com.esri.core.geometry.ogc.OGCGeometry;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.udf.esri.GeometryUtils;
import org.apache.hadoop.hive.ql.udf.esri.LogUtils;
import org.apache.hadoop.hive.ql.udf.esri.ST_GeometryProcessing;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.io.BytesWritable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(name="ST_Buffer", value="_FUNC_(ST_Geometry, distance) - ST_Geometry buffered by distance", extended="Example:\n  SELECT _FUNC_(ST_Point(0, 0), 1) FROM src LIMIT 1;   -- polygon approximating a unit circle\n")
public class ST_Buffer
extends ST_GeometryProcessing {
    static final Logger LOG = LoggerFactory.getLogger((String)ST_Buffer.class.getName());

    public BytesWritable evaluate(BytesWritable geometryref1, DoubleWritable distance) {
        if (geometryref1 == null || geometryref1.getLength() == 0 || distance == null) {
            return null;
        }
        OGCGeometry ogcGeometry = GeometryUtils.geometryFromEsriShape(geometryref1);
        if (ogcGeometry == null) {
            LogUtils.Log_ArgumentsNull(LOG);
            return null;
        }
        OGCGeometry bufferedGeometry = ogcGeometry.buffer(distance.get());
        return GeometryUtils.geometryToEsriShapeBytesWritable(bufferedGeometry);
    }
}

