/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreUtils;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.txn.entities.CompactionInfo;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.exec.repl.util.ReplUtils;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorThread;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorUtil;
import org.apache.hadoop.hive.ql.txn.compactor.RemoteCompactorUtil;
import org.apache.thrift.TException;

public class RemoteCompactorThread
extends CompactorThread {
    protected IMetaStoreClient msc;
    private String poolName;

    public String getPoolName() {
        return this.poolName;
    }

    public void setPoolName(String poolName) {
        this.poolName = poolName;
    }

    @Override
    public void init(AtomicBoolean stop) throws Exception {
        super.init(stop);
        this.msc = HiveMetaStoreUtils.getHiveMetastoreClient((HiveConf)this.conf);
    }

    @Override
    Table resolveTable(CompactionInfo ci) throws MetaException {
        return RemoteCompactorUtil.resolveTable(this.conf, this.msc, ci);
    }

    @Override
    boolean replIsCompactionDisabledForDatabase(String dbName) throws TException {
        try {
            Database database = this.msc.getDatabase(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName);
            return ReplUtils.isFirstIncPending(database.getParameters());
        }
        catch (NoSuchObjectException e) {
            LOG.info("Unable to find database " + dbName);
            return true;
        }
    }

    @Override
    List<Partition> getPartitionsByNames(CompactionInfo ci) throws MetaException {
        return RemoteCompactorUtil.getPartitionsByNames(this.msc, ci.dbname, ci.tableName, ci.tableName);
    }

    @Override
    protected Partition resolvePartition(CompactionInfo ci) throws MetaException {
        return CompactorUtil.resolvePartition(this.conf, this.msc, ci.dbname, ci.tableName, ci.partName, CompactorUtil.METADATA_FETCH_MODE.REMOTE);
    }
}

