/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.processors;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.compress.archivers.jar.JarArchiveEntry;
import org.apache.commons.compress.archivers.jar.JarArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.hive.conf.HiveVariableSource;
import org.apache.hadoop.hive.conf.VariableSubstitution;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessorException;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.processors.CommandUtil;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Path;
import org.codehaus.groovy.ant.Groovyc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompileProcessor
implements CommandProcessor {
    public static final Logger LOG = LoggerFactory.getLogger((String)CompileProcessor.class.getName());
    public static final SessionState.LogHelper console = new SessionState.LogHelper(LOG);
    public static final String IO_TMP_DIR = "java.io.tmpdir";
    public static final String GROOVY = "GROOVY";
    public static final String AS = "AS";
    public static final String NAMED = "NAMED";
    private static final String SYNTAX = "syntax: COMPILE ` some code here ` AS groovy NAMED something.groovy";
    private static final AtomicInteger runCount = new AtomicInteger(0);
    private String lang;
    private String code;
    private String named;
    private String command;
    private int myId;

    @Override
    public CommandProcessorResponse run(String command) throws CommandProcessorException {
        SessionState ss = SessionState.get();
        this.command = command;
        CommandProcessorResponse authErrResp = CommandUtil.authorizeCommand(ss, HiveOperationType.COMPILE, Arrays.asList(command));
        if (authErrResp != null) {
            return authErrResp;
        }
        this.myId = runCount.getAndIncrement();
        this.parse(ss);
        CommandProcessorResponse result = this.compile(ss);
        return result;
    }

    @VisibleForTesting
    void parse(SessionState ss) throws CommandProcessorException {
        if (ss != null) {
            this.command = new VariableSubstitution(new HiveVariableSource(){

                public Map<String, String> getHiveVariable() {
                    return SessionState.get().getHiveVariables();
                }
            }).substitute(ss.getConf(), this.command);
        }
        if (this.command == null || this.command.length() == 0) {
            throw new CommandProcessorException("Command was empty");
        }
        StringBuilder toCompile = new StringBuilder();
        int startPosition = 0;
        int endPosition = -1;
        while (this.command.charAt(startPosition++) != '`' && startPosition < this.command.length()) {
        }
        if (startPosition == this.command.length()) {
            throw new CommandProcessorException(SYNTAX);
        }
        for (int i = startPosition; i < this.command.length(); ++i) {
            if (this.command.charAt(i) == '\\') {
                toCompile.append(this.command.charAt(i + 1));
                ++i;
                continue;
            }
            if (this.command.charAt(i) == '`') {
                endPosition = i;
                break;
            }
            toCompile.append(this.command.charAt(i));
        }
        if (endPosition == -1) {
            throw new CommandProcessorException(SYNTAX);
        }
        StringTokenizer st = new StringTokenizer(this.command.substring(endPosition + 1), " ");
        if (st.countTokens() != 4) {
            throw new CommandProcessorException(SYNTAX);
        }
        String shouldBeAs = st.nextToken();
        if (!shouldBeAs.equalsIgnoreCase(AS)) {
            throw new CommandProcessorException(SYNTAX);
        }
        this.setLang(st.nextToken());
        if (!this.lang.equalsIgnoreCase(GROOVY)) {
            throw new CommandProcessorException("Can not compile " + this.lang + ". Hive can only compile GROOVY");
        }
        String shouldBeNamed = st.nextToken();
        if (!shouldBeNamed.equalsIgnoreCase(NAMED)) {
            throw new CommandProcessorException(SYNTAX);
        }
        this.setNamed(st.nextToken());
        this.setCode(toCompile.toString());
    }

    @VisibleForTesting
    CommandProcessorResponse compile(SessionState ss) throws CommandProcessorException {
        long runStamp;
        String lockout = "rwx------";
        Project proj = new Project();
        String ioTempDir = System.getProperty(IO_TMP_DIR);
        File ioTempFile = new File(ioTempDir);
        if (!ioTempFile.exists()) {
            throw new CommandProcessorException(ioTempDir + " does not exists");
        }
        if (!ioTempFile.isDirectory() || !ioTempFile.canWrite()) {
            throw new CommandProcessorException(ioTempDir + " is not a writable directory");
        }
        String user = ss != null ? ss.getUserName() : "anonymous";
        File sessionTempFile = new File(ioTempDir, user + "_" + (runStamp = System.currentTimeMillis()));
        if (!sessionTempFile.exists()) {
            sessionTempFile.mkdir();
            CompileProcessor.setPosixFilePermissions(sessionTempFile, lockout, true);
        }
        Groovyc g = new Groovyc();
        String jarId = this.myId + "_" + runStamp;
        g.setProject(proj);
        Path sourcePath = new Path(proj);
        File destination = new File(sessionTempFile, jarId + "out");
        g.setDestdir(destination);
        File input = new File(sessionTempFile, jarId + "in");
        sourcePath.setLocation(input);
        g.setSrcdir(sourcePath);
        input.mkdir();
        File fileToWrite = new File(input, this.named);
        try {
            Files.write(Paths.get(fileToWrite.toURI()), this.code.getBytes(Charset.forName("UTF-8")), StandardOpenOption.CREATE_NEW);
        }
        catch (IOException e1) {
            throw new CommandProcessorException("writing file", e1);
        }
        destination.mkdir();
        try {
            g.execute();
        }
        catch (BuildException ex) {
            throw new CommandProcessorException("Problem compiling", ex);
        }
        File testArchive = new File(sessionTempFile, jarId + ".jar");
        JarArchiveOutputStream out = null;
        try {
            out = new JarArchiveOutputStream((OutputStream)new FileOutputStream(testArchive));
            for (File f : destination.listFiles()) {
                JarArchiveEntry jentry = new JarArchiveEntry(f.getName());
                FileInputStream fis = new FileInputStream(f);
                out.putArchiveEntry((ZipArchiveEntry)jentry);
                IOUtils.copy((InputStream)fis, (OutputStream)out);
                fis.close();
                out.closeArchiveEntry();
            }
            out.finish();
            CompileProcessor.setPosixFilePermissions(testArchive, lockout, false);
        }
        catch (IOException e) {
            throw new CommandProcessorException("Exception while writing jar", e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
                try {
                    if (input.exists()) {
                        FileUtils.forceDeleteOnExit((File)input);
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (destination.exists()) {
                        FileUtils.forceDeleteOnExit((File)destination);
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (testArchive != null && testArchive.exists()) {
                        testArchive.deleteOnExit();
                    }
                }
                catch (Exception exception) {}
            }
        }
        if (ss != null) {
            ss.add_resource(SessionState.ResourceType.JAR, testArchive.getAbsolutePath());
        }
        CommandProcessorResponse good = new CommandProcessorResponse(null, testArchive.getAbsolutePath());
        return good;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getNamed() {
        return this.named;
    }

    public void setNamed(String named) {
        this.named = named;
    }

    public String getCommand() {
        return this.command;
    }

    @Override
    public void close() throws Exception {
    }

    private static synchronized void setPosixFilePermissions(File file, String permsAsString, boolean warnOnly) {
        block2: {
            Set<PosixFilePermission> perms = PosixFilePermissions.fromString(permsAsString);
            try {
                Files.setPosixFilePermissions(Paths.get(file.toURI()), perms);
            }
            catch (IOException ioe) {
                LOG.warn("Failed to set file permissions on " + file.getAbsolutePath());
                if (warnOnly) break block2;
                throw new RuntimeException("Exception setting file permissions on " + file.getAbsolutePath());
            }
        }
    }
}

