/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.type;

import java.util.Map;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.type.ConstraintExprGenerator;
import org.apache.hadoop.hive.ql.parse.type.ExprNodeDescExprFactory;
import org.apache.hadoop.hive.ql.parse.type.JoinCondTypeCheckProcFactory;
import org.apache.hadoop.hive.ql.parse.type.TypeCheckCtx;
import org.apache.hadoop.hive.ql.parse.type.TypeCheckProcFactory;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;

public class ExprNodeTypeCheck {
    private ExprNodeTypeCheck() {
    }

    public static Map<ASTNode, ExprNodeDesc> genExprNode(ASTNode expr, TypeCheckCtx tcCtx) throws SemanticException {
        TypeCheckProcFactory<ExprNodeDesc> factory = new TypeCheckProcFactory<ExprNodeDesc>(new ExprNodeDescExprFactory());
        return factory.genExprNode(expr, tcCtx);
    }

    public static Map<ASTNode, ExprNodeDesc> genExprNodeJoinCond(ASTNode expr, TypeCheckCtx tcCtx) throws SemanticException {
        JoinCondTypeCheckProcFactory<ExprNodeDesc> typeCheckProcFactory = new JoinCondTypeCheckProcFactory<ExprNodeDesc>(new ExprNodeDescExprFactory());
        return typeCheckProcFactory.genExprNode(expr, tcCtx);
    }

    public static TypeCheckProcFactory.DefaultExprProcessor getExprNodeDefaultExprProcessor() {
        TypeCheckProcFactory<ExprNodeDesc> factory = new TypeCheckProcFactory<ExprNodeDesc>(new ExprNodeDescExprFactory());
        return factory.getDefaultExprProcessor();
    }

    public static ExprNodeDesc toExprNode(ColumnInfo columnInfo, RowResolver rowResolver) throws SemanticException {
        ExprNodeDescExprFactory factory = new ExprNodeDescExprFactory();
        return factory.toExpr(columnInfo, rowResolver, 0);
    }

    public static ExprNodeDesc genConstraintsExpr(HiveConf conf, Table targetTable, boolean updateStatement, RowResolver inputRR) throws SemanticException {
        return new ConstraintExprGenerator<ExprNodeDesc>(conf, new TypeCheckProcFactory<ExprNodeDesc>(new ExprNodeDescExprFactory())).genConstraintsExpr(targetTable, updateStatement, inputRR);
    }
}

