/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.rewrite.sql;

import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.rewrite.sql.MultiInsertSqlGenerator;
import org.apache.hadoop.hive.ql.parse.rewrite.sql.NativeAcidMultiInsertSqlGenerator;
import org.apache.hadoop.hive.ql.parse.rewrite.sql.NonNativeAcidMultiInsertSqlGenerator;

public class SqlGeneratorFactory {
    public static final String DELETE_PREFIX = "__d__";
    public static final String TARGET_PREFIX = "t__";
    public static final String SUB_QUERY_ALIAS = "s";
    private final Table targetTable;
    private final String targetTableFullName;
    private final HiveConf conf;
    private final String subQueryAlias;
    private final String deletePrefix;

    public SqlGeneratorFactory(Table targetTable, String targetTableFullName, HiveConf conf, String subQueryAlias, String deletePrefix) {
        this.targetTable = targetTable;
        this.targetTableFullName = targetTableFullName;
        this.conf = conf;
        this.subQueryAlias = subQueryAlias;
        this.deletePrefix = deletePrefix;
    }

    public MultiInsertSqlGenerator createSqlGenerator() {
        boolean nonNativeAcid = AcidUtils.isNonNativeAcidTable(this.targetTable);
        return nonNativeAcid ? new NonNativeAcidMultiInsertSqlGenerator(this.targetTable, this.targetTableFullName, this.conf, this.subQueryAlias, this.deletePrefix) : new NativeAcidMultiInsertSqlGenerator(this.targetTable, this.targetTableFullName, this.conf, this.subQueryAlias);
    }
}

