/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.dump;

import com.cronutils.utils.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.repl.dump.ExportJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportService {
    private ExecutorService execService;
    private static final Logger LOG = LoggerFactory.getLogger(ExportService.class);
    private final List<Future<?>> futures = new LinkedList();
    private final AtomicBoolean isServiceRunning = new AtomicBoolean(false);
    private final int threadPoolSizeLimit = 100;

    public ExportService(HiveConf hiveConf) {
        int nDumpThreads = hiveConf.getIntVar(HiveConf.ConfVars.REPL_TABLE_DUMP_PARALLELISM);
        if (nDumpThreads == 0) {
            LOG.warn("ExportService is disabled since thread pool size (REPL_TABLE_DUMP_PARALLELISM) is specified as 0");
            this.isServiceRunning.set(false);
            return;
        }
        if (nDumpThreads > 100) {
            LOG.warn("Thread pool size for ExportService (REPL_TABLE_DUMP_PARALLELISM) is specified higher than limit. Choosing thread pool size as 100");
            nDumpThreads = 100;
        }
        ThreadFactory namingThreadFactory = new ThreadFactoryBuilder().setNameFormat("TableAndPartition-dump-thread-%d").build();
        this.execService = Executors.newFixedThreadPool(nDumpThreads, namingThreadFactory);
        LOG.info("ExportService started with thread pool size {} ", (Object)nDumpThreads);
        this.isServiceRunning.set(true);
    }

    public boolean isExportServiceRunning() {
        return this.isServiceRunning.get();
    }

    public void submit(ExportJob job) {
        assert (this.execService != null);
        this.futures.add(this.execService.submit(job));
    }

    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        assert (this.execService != null);
        LOG.debug("ExportService : awaiting termination of submitted jobs");
        return this.execService.awaitTermination(timeout, unit);
    }

    public void waitForTasksToFinishAndShutdown() throws HiveException {
        for (Future<?> future : this.futures) {
            try {
                future.get();
            }
            catch (Exception e) {
                LOG.error("ExportService thread failed to perform task ", e.getCause());
                this.futures.remove(future);
                throw new HiveException(e.getCause().getMessage(), e.getCause());
            }
        }
        assert (this.execService != null);
        LOG.debug("ExportService got shutdown");
        this.execService.shutdown();
        this.isServiceRunning.set(false);
    }

    @VisibleForTesting
    public long getTotalTaskEverExecuted() {
        assert (this.execService != null);
        ThreadPoolExecutor executor = (ThreadPoolExecutor)this.execService;
        return executor.getTaskCount();
    }
}

