/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.calcite.rel.RelNode;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelFactories;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveHepExtractRelNodeRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveRelFieldTrimmer;

public class HiveFieldTrimmerRule
extends RelOptRule {
    private final boolean fetchStats;
    private boolean triggered;

    public HiveFieldTrimmerRule(boolean fetchStats) {
        this(fetchStats, "HiveFieldTrimmerRule");
    }

    protected HiveFieldTrimmerRule(boolean fetchStats, String description) {
        super(HiveFieldTrimmerRule.operand(RelNode.class, (RelOptRuleOperandChildren)HiveFieldTrimmerRule.any()), HiveRelFactories.HIVE_BUILDER, description);
        this.fetchStats = fetchStats;
        this.triggered = false;
    }

    public void onMatch(RelOptRuleCall call) {
        if (this.triggered) {
            return;
        }
        RelNode node = call.rel(0);
        HepRelVertex root = (HepRelVertex)call.getPlanner().getRoot();
        if (root.getCurrentRel() != node) {
            return;
        }
        node = HiveHepExtractRelNodeRule.execute(node);
        call.transformTo(this.trim(call, node));
        this.triggered = true;
    }

    protected RelNode trim(RelOptRuleCall call, RelNode node) {
        return HiveRelFieldTrimmer.get(this.fetchStats).trim(call.builder(), node);
    }
}

