/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelFactories;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveAggregate;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveGroupingID;

public class HiveAggregateSplitRule
extends RelOptRule {
    public static final HiveAggregateSplitRule INSTANCE = new HiveAggregateSplitRule(HiveAggregate.class, HiveRelFactories.HIVE_BUILDER);

    private HiveAggregateSplitRule(Class<? extends Aggregate> aggregateClass, RelBuilderFactory relBuilderFactory) {
        super(HiveAggregateSplitRule.operandJ(aggregateClass, null, agg -> agg.getGroupType() != Aggregate.Group.SIMPLE, (RelOptRuleOperandChildren)HiveAggregateSplitRule.any()), relBuilderFactory, null);
    }

    public void onMatch(RelOptRuleCall call) {
        Aggregate aggregate = (Aggregate)call.rel(0);
        RelBuilder relBuilder = call.builder();
        ImmutableBitSet bottomAggregateGroupSet = aggregate.getGroupSet();
        ArrayList<AggregateCall> topAggregateCalls = new ArrayList<AggregateCall>();
        for (int i = 0; i < aggregate.getAggCallList().size(); ++i) {
            AggregateCall aggregateCall = (AggregateCall)aggregate.getAggCallList().get(i);
            if (aggregateCall.isDistinct()) {
                return;
            }
            if (aggregateCall.getAggregation().equals((Object)HiveGroupingID.INSTANCE)) {
                return;
            }
            if (aggregateCall.filterArg >= 0) {
                return;
            }
            SqlAggFunction aggFunction = aggregateCall.getAggregation().getRollup();
            if (aggFunction == null) {
                return;
            }
            topAggregateCalls.add(AggregateCall.create((SqlAggFunction)aggFunction, (boolean)aggregateCall.isDistinct(), (boolean)aggregateCall.isApproximate(), (List)ImmutableList.of((Object)(bottomAggregateGroupSet.cardinality() + i)), (int)-1, (RelCollation)aggregateCall.collation, (RelDataType)aggregateCall.type, (String)aggregateCall.name));
        }
        Boolean isUnique = aggregate.getCluster().getMetadataQuery().areColumnsUnique(aggregate.getInput(), bottomAggregateGroupSet);
        if (isUnique != null && isUnique.booleanValue()) {
            return;
        }
        ImmutableBitSet topAggregateGroupSet = ImmutableBitSet.range((int)0, (int)bottomAggregateGroupSet.cardinality());
        HashMap map = new HashMap();
        bottomAggregateGroupSet.forEach(k -> map.put(k, map.size()));
        ImmutableList topAggregateGroupSets = ImmutableBitSet.ORDERING.immutableSortedCopy(ImmutableBitSet.permute((Iterable)aggregate.groupSets, map));
        relBuilder.push(aggregate.getInput()).aggregate(relBuilder.groupKey(bottomAggregateGroupSet), aggregate.getAggCallList()).aggregate(relBuilder.groupKey(topAggregateGroupSet, (Iterable)topAggregateGroupSets), topAggregateCalls);
        call.transformTo(relBuilder.build());
    }
}

