/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.util.ArrayList;
import java.util.Stack;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.SemanticNodeProcessor;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ColStatistics;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.Statistics;
import org.apache.hadoop.hive.ql.stats.StatsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetHashGroupByMinReduction
implements SemanticNodeProcessor {
    private static final Logger LOG = LoggerFactory.getLogger((String)SetHashGroupByMinReduction.class.getName());

    @Override
    public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procContext, Object ... nodeOutputs) throws SemanticException {
        GroupByOperator groupByOperator = (GroupByOperator)nd;
        GroupByDesc desc = (GroupByDesc)groupByOperator.getConf();
        if (desc.getMode() != GroupByDesc.Mode.HASH || groupByOperator.getStatistics().getBasicStatsState() != Statistics.State.COMPLETE || groupByOperator.getStatistics().getColumnStatsState() != Statistics.State.COMPLETE) {
            return null;
        }
        ArrayList<ColStatistics> colStats = new ArrayList<ColStatistics>();
        for (int i = 0; i < desc.getKeys().size(); ++i) {
            ColumnInfo ci = groupByOperator.getSchema().getSignature().get(i);
            colStats.add(groupByOperator.getStatistics().getColumnStatisticsFromColName(ci.getInternalName()));
        }
        Statistics parentStats = groupByOperator.getParentOperators().get(0).getStatistics();
        long ndvProduct = StatsUtils.computeNDVGroupingColumns(colStats, parentStats, true);
        if (ndvProduct == 0L) {
            return null;
        }
        long numRows = parentStats.getNumRows();
        if (ndvProduct > numRows) {
            ndvProduct = numRows;
        }
        float defaultMinReductionHashAggrFactor = desc.getMinReductionHashAggr();
        float minReductionHashAggrFactor = 1.0f - (float)ndvProduct / (float)numRows;
        float defaultMinReductionHashAggrFactorLowerBound = desc.getMinReductionHashAggrLowerBound();
        if (minReductionHashAggrFactor < defaultMinReductionHashAggrFactorLowerBound) {
            minReductionHashAggrFactor = defaultMinReductionHashAggrFactorLowerBound;
        }
        if (minReductionHashAggrFactor < defaultMinReductionHashAggrFactor) {
            desc.setMinReductionHashAggr(minReductionHashAggrFactor);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Minimum reduction for hash group by operator {} set to {}", (Object)groupByOperator, (Object)Float.valueOf(minReductionHashAggrFactor));
            }
        }
        return null;
    }
}

