/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.util.LinkedHashMap;
import java.util.Stack;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.SemanticNodeProcessor;
import org.apache.hadoop.hive.ql.optimizer.GenMRProcContext;
import org.apache.hadoop.hive.ql.optimizer.GenMapRedUtils;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;

public class GenMRRedSink1
implements SemanticNodeProcessor {
    @Override
    public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx opProcCtx, Object ... nodeOutputs) throws SemanticException {
        ReduceSinkOperator op = (ReduceSinkOperator)nd;
        GenMRProcContext ctx = (GenMRProcContext)opProcCtx;
        LinkedHashMap<Operator<? extends OperatorDesc>, GenMRProcContext.GenMapRedCtx> mapCurrCtx = ctx.getMapCurrCtx();
        GenMRProcContext.GenMapRedCtx mapredCtx = (GenMRProcContext.GenMapRedCtx)mapCurrCtx.get(stack.get(stack.size() - 2));
        Task<?> currTask = mapredCtx.getCurrTask();
        MapredWork currPlan = (MapredWork)currTask.getWork();
        String currAliasId = mapredCtx.getCurrAliasId();
        if (op.getNumChild() != 1) {
            throw new IllegalStateException("Expecting operator " + op + " to have one child. But found multiple children : " + op.getChildOperators());
        }
        Operator<OperatorDesc> reducer = op.getChildOperators().get(0);
        Task<?> oldTask = ctx.getOpTaskMap().get(reducer);
        ctx.setCurrAliasId(currAliasId);
        ctx.setCurrTask(currTask);
        if (oldTask == null) {
            if (currPlan.getReduceWork() == null) {
                GenMapRedUtils.initPlan(op, ctx);
            } else {
                GenMapRedUtils.splitPlan(op, ctx);
            }
        } else {
            GenMapRedUtils.joinPlan(currTask, oldTask, ctx);
            currTask = oldTask;
            ctx.setCurrTask(currTask);
        }
        mapCurrCtx.put(op, new GenMRProcContext.GenMapRedCtx(ctx.getCurrTask(), ctx.getCurrAliasId()));
        if (GenMapRedUtils.hasBranchFinished(nodeOutputs)) {
            ctx.addRootIfPossible(currTask);
            return false;
        }
        return true;
    }
}

