/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata.formatting;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.WMValidateResourcePlanResponse;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.formatting.MapBuilder;
import org.apache.hadoop.hive.ql.metadata.formatting.MetaDataFormatter;

public class JsonMetaDataFormatter
implements MetaDataFormatter {
    private void asJson(OutputStream out, Map<String, Object> data) throws HiveException {
        try {
            new ObjectMapper().writeValue(out, data);
        }
        catch (IOException e) {
            throw new HiveException("Unable to convert to json", (Throwable)e);
        }
    }

    @Override
    public void error(OutputStream out, String msg, int errorCode, String sqlState) throws HiveException {
        this.error(out, msg, errorCode, sqlState, null);
    }

    @Override
    public void error(OutputStream out, String errorMessage, int errorCode, String sqlState, String errorDetail) throws HiveException {
        MapBuilder mb = MapBuilder.create().put("error", errorMessage);
        if (errorDetail != null) {
            mb.put("errorDetail", errorDetail);
        }
        mb.put("errorCode", errorCode);
        if (sqlState != null) {
            mb.put("sqlState", sqlState);
        }
        this.asJson(out, mb.build());
    }

    @Override
    public void showErrors(DataOutputStream out, WMValidateResourcePlanResponse response) throws HiveException {
        try (JsonGenerator generator = new ObjectMapper().getJsonFactory().createJsonGenerator((OutputStream)out);){
            generator.writeStartObject();
            generator.writeArrayFieldStart("errors");
            for (String error : response.getErrors()) {
                generator.writeString(error);
            }
            generator.writeEndArray();
            generator.writeArrayFieldStart("warnings");
            for (String error : response.getWarnings()) {
                generator.writeString(error);
            }
            generator.writeEndArray();
            generator.writeEndObject();
        }
        catch (IOException e) {
            throw new HiveException((Throwable)e);
        }
    }
}

