/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.log;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.tez.TezTask;
import org.apache.hadoop.hive.ql.log.HushableRandomAccessFileAppender;
import org.apache.hadoop.hive.ql.log.NullAppender;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.session.OperationLog;
import org.apache.hadoop.hive.ql.stats.BasicStatsTask;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.routing.IdlePurgePolicy;
import org.apache.logging.log4j.core.appender.routing.PurgePolicy;
import org.apache.logging.log4j.core.appender.routing.Route;
import org.apache.logging.log4j.core.appender.routing.Routes;
import org.apache.logging.log4j.core.appender.routing.RoutingAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.Node;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.config.plugins.processor.PluginEntry;
import org.apache.logging.log4j.core.config.plugins.util.PluginType;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogDivertAppender {
    private static final Logger LOG = LoggerFactory.getLogger((String)LogDivertAppender.class.getName());
    public static final String verboseLayout = "%d{yy/MM/dd HH:mm:ss} %p %c{2}: %m%n";
    public static final String nonVerboseLayout = "%-5p : %m%n";
    public static final String QUERY_ROUTING_APPENDER = "query-routing";

    public static void registerRoutingAppender(org.apache.hadoop.conf.Configuration conf) {
        if (!HiveConf.getBoolVar((org.apache.hadoop.conf.Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SERVER2_LOGGING_OPERATION_ENABLED, (boolean)false)) {
            return;
        }
        String loggingLevel = HiveConf.getVar((org.apache.hadoop.conf.Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SERVER2_LOGGING_OPERATION_LEVEL);
        OperationLog.LoggingLevel loggingMode = OperationLog.getLoggingLevel(loggingLevel);
        String layout = loggingMode == OperationLog.LoggingLevel.VERBOSE ? verboseLayout : nonVerboseLayout;
        PluginEntry nullEntry = new PluginEntry();
        nullEntry.setClassName(NullAppender.class.getName());
        nullEntry.setKey("null");
        nullEntry.setName("appender");
        PluginType nullChildType = new PluginType(nullEntry, NullAppender.class, "appender");
        Node nullChildNode = new Node(null, "Null", nullChildType);
        PluginEntry defaultEntry = new PluginEntry();
        defaultEntry.setClassName(Route.class.getName());
        defaultEntry.setKey("route");
        defaultEntry.setName("Route");
        PluginType defaultType = new PluginType(defaultEntry, Route.class, "Route");
        Node nullNode = new Node(null, "Route", defaultType);
        nullNode.getChildren().add(nullChildNode);
        Route defaultRoute = Route.createRoute(null, (String)"${ctx:queryId}", (Node)nullNode);
        PluginEntry entry = new PluginEntry();
        entry.setClassName(Route.class.getName());
        entry.setKey("route");
        entry.setName("Route");
        PluginType type = new PluginType(entry, Route.class, "Route");
        Node node = new Node(null, "Route", type);
        PluginEntry childEntry = new PluginEntry();
        childEntry.setClassName(HushableRandomAccessFileAppender.class.getName());
        childEntry.setKey("HushableMutableRandomAccess");
        childEntry.setName("appender");
        PluginType childType = new PluginType(childEntry, HushableRandomAccessFileAppender.class, "appender");
        Node childNode = new Node(node, "HushableMutableRandomAccess", childType);
        childNode.getAttributes().put("name", "query-file-appender");
        childNode.getAttributes().put("fileName", "${ctx:operationLogLocation}/${ctx:sessionId}/${ctx:queryId}");
        node.getChildren().add(childNode);
        PluginEntry filterEntry = new PluginEntry();
        filterEntry.setClassName(NameFilter.class.getName());
        filterEntry.setKey("namefilter");
        filterEntry.setName("namefilter");
        PluginType filterType = new PluginType(filterEntry, NameFilter.class, "filter");
        Node filterNode = new Node(childNode, "NameFilter", filterType);
        filterNode.getAttributes().put("loggingLevel", loggingMode.name());
        childNode.getChildren().add(filterNode);
        PluginEntry layoutEntry = new PluginEntry();
        layoutEntry.setClassName(PatternLayout.class.getName());
        layoutEntry.setKey("patternlayout");
        layoutEntry.setName("layout");
        PluginType layoutType = new PluginType(layoutEntry, PatternLayout.class, "layout");
        Node layoutNode = new Node(childNode, "PatternLayout", layoutType);
        layoutNode.getAttributes().put("pattern", layout);
        childNode.getChildren().add(layoutNode);
        Route mdcRoute = Route.createRoute(null, null, (Node)node);
        Routes routes = Routes.createRoutes((String)"${ctx:queryId}", (Route[])new Route[]{defaultRoute, mdcRoute});
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration configuration = context.getConfiguration();
        String timeToLive = String.valueOf(HiveConf.getTimeVar((org.apache.hadoop.conf.Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SERVER2_OPERATION_LOG_PURGEPOLICY_TIMETOLIVE, (TimeUnit)TimeUnit.SECONDS));
        PurgePolicy purgePolicy = IdlePurgePolicy.createPurgePolicy((String)timeToLive, null, (String)"SECONDS", (Configuration)configuration);
        configuration.getScheduler().incrementScheduledItems();
        RoutingAppender routingAppender = RoutingAppender.createAppender((String)QUERY_ROUTING_APPENDER, (String)"true", (Routes)routes, (Configuration)configuration, null, (PurgePolicy)purgePolicy, null);
        LoggerConfig loggerConfig = configuration.getRootLogger();
        loggerConfig.addAppender((Appender)routingAppender, null, null);
        context.updateLoggers();
        routingAppender.start();
    }

    @Plugin(name="NameFilter", category="Core", elementType="filter", printObject=true)
    private static class NameFilter
    extends AbstractFilter {
        private Pattern namePattern;
        private OperationLog.LoggingLevel loggingMode;
        private static final Pattern verboseExcludeNamePattern = Pattern.compile(Joiner.on((String)"|").join((Object[])new String[]{LOG.getName(), OperationLog.class.getName()}));
        private static final Pattern executionIncludeNamePattern = Pattern.compile(Joiner.on((String)"|").join((Object[])new String[]{"org.apache.hadoop.mapreduce.JobSubmitter", "org.apache.hadoop.mapreduce.Job", "SessionState", "ReplState", Task.class.getName(), TezTask.class.getName(), Driver.class.getName(), BasicStatsTask.class.getName()}));
        private static final Pattern performanceIncludeNamePattern = Pattern.compile(executionIncludeNamePattern.pattern() + "|" + PerfLogger.class.getName());

        private void setCurrentNamePattern(OperationLog.LoggingLevel mode) {
            if (mode == OperationLog.LoggingLevel.VERBOSE) {
                this.namePattern = verboseExcludeNamePattern;
            } else if (mode == OperationLog.LoggingLevel.EXECUTION) {
                this.namePattern = executionIncludeNamePattern;
            } else if (mode == OperationLog.LoggingLevel.PERFORMANCE) {
                this.namePattern = performanceIncludeNamePattern;
            }
        }

        public NameFilter(OperationLog.LoggingLevel loggingMode) {
            this.loggingMode = loggingMode;
            this.setCurrentNamePattern(loggingMode);
        }

        public Filter.Result filter(LogEvent event) {
            boolean isMatch;
            boolean excludeMatches = this.loggingMode == OperationLog.LoggingLevel.VERBOSE;
            String logLevel = (String)event.getContextMap().get("operationLogLevel");
            OperationLog.LoggingLevel currentLoggingMode = OperationLog.getLoggingLevel(logLevel = logLevel == null ? "" : logLevel);
            if (currentLoggingMode == OperationLog.LoggingLevel.NONE) {
                return Filter.Result.DENY;
            }
            if (currentLoggingMode != this.loggingMode) {
                this.loggingMode = currentLoggingMode;
                excludeMatches = this.loggingMode == OperationLog.LoggingLevel.VERBOSE;
                this.setCurrentNamePattern(this.loggingMode);
            }
            if (excludeMatches == (isMatch = this.namePattern.matcher(event.getLoggerName()).matches())) {
                return Filter.Result.DENY;
            }
            return Filter.Result.NEUTRAL;
        }

        @PluginFactory
        public static NameFilter createFilter(@PluginAttribute(value="loggingLevel") String loggingLevel) {
            Preconditions.checkNotNull((Object)loggingLevel, (Object)("loggingLevel must be specified for " + NameFilter.class.getName()));
            return new NameFilter(OperationLog.getLoggingLevel(loggingLevel));
        }
    }
}

