/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.convert;

import java.util.Map;
import java.util.Optional;
import org.apache.hadoop.hive.ql.io.parquet.convert.ConverterParent;
import org.apache.hadoop.hive.ql.io.parquet.convert.ETypeConverter;
import org.apache.hadoop.hive.ql.io.parquet.convert.HiveCollectionConverter;
import org.apache.hadoop.hive.ql.io.parquet.convert.HiveStructConverter;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.Writable;
import org.apache.parquet.io.api.Converter;
import org.apache.parquet.io.api.GroupConverter;
import org.apache.parquet.io.api.PrimitiveConverter;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;

public abstract class HiveGroupConverter
extends GroupConverter
implements ConverterParent {
    private Map<String, String> metadata;

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    protected static PrimitiveConverter getConverterFromDescription(PrimitiveType type, int index, ConverterParent parent, TypeInfo hiveTypeInfo) {
        if (type == null) {
            return null;
        }
        return ETypeConverter.getNewConverter(type, index, parent, hiveTypeInfo);
    }

    protected static HiveGroupConverter getConverterFromDescription(final GroupType type, final int index, final ConverterParent parent, final TypeInfo hiveTypeInfo) {
        Optional converter;
        if (type == null) {
            return null;
        }
        if (type.getLogicalTypeAnnotation() != null && (converter = type.getLogicalTypeAnnotation().accept((LogicalTypeAnnotation.LogicalTypeAnnotationVisitor)new LogicalTypeAnnotation.LogicalTypeAnnotationVisitor<HiveGroupConverter>(){

            public Optional<HiveGroupConverter> visit(LogicalTypeAnnotation.ListLogicalTypeAnnotation logicalTypeAnnotation) {
                return Optional.of(HiveCollectionConverter.forList(type, parent, index, hiveTypeInfo));
            }

            public Optional<HiveGroupConverter> visit(LogicalTypeAnnotation.MapLogicalTypeAnnotation logicalTypeAnnotation) {
                return Optional.of(HiveCollectionConverter.forMap(type, parent, index, hiveTypeInfo));
            }

            public Optional<HiveGroupConverter> visit(LogicalTypeAnnotation.MapKeyValueTypeAnnotation logicalTypeAnnotation) {
                return Optional.of(HiveCollectionConverter.forMap(type, parent, index, hiveTypeInfo));
            }
        })).isPresent()) {
            return (HiveGroupConverter)converter.get();
        }
        return new HiveStructConverter(type, parent, index, hiveTypeInfo);
    }

    protected static Converter getConverterFromDescription(Type type, int index, ConverterParent parent, TypeInfo hiveTypeInfo) {
        if (type == null) {
            return null;
        }
        if (type.isPrimitive()) {
            return HiveGroupConverter.getConverterFromDescription(type.asPrimitiveType(), index, parent, hiveTypeInfo);
        }
        return HiveGroupConverter.getConverterFromDescription(type.asGroupType(), index, parent, hiveTypeInfo);
    }

    @Override
    public abstract void set(int var1, Writable var2);
}

