/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.ptf;

import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorBase;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFGroupBatches;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;
import org.apache.hadoop.hive.ql.udf.ptf.Range;

public abstract class VectorPTFEvaluatorAbstractAvg<T>
extends VectorPTFEvaluatorBase {
    protected boolean isGroupResultNull;
    protected T sum;
    protected int nonNullGroupCount;
    protected Range previousRange = null;
    protected T previousSum = null;
    protected int previousCount;

    public VectorPTFEvaluatorAbstractAvg(WindowFrameDef windowFrameDef, VectorExpression inputVecExpr, int outputColumnNum) {
        super(windowFrameDef, inputVecExpr, outputColumnNum);
    }

    @Override
    public boolean canRunOptimizedCalculation(int rowNum, Range range) {
        return this.previousRange != null && range.getSize() > range.getDiff(this.previousRange);
    }

    @Override
    public Object runOnRange(int rowNum, Range range, VectorPTFGroupBatches batches) throws HiveException {
        Range r1 = new Range(this.previousRange.getStart(), range.getStart(), batches);
        Range r2 = new Range(this.previousRange.getEnd(), range.getEnd(), batches);
        batches.runEvaluatorOnRange(this, r1, false);
        T sum1 = this.computeValue(this.sum);
        int count1 = this.nonNullGroupCount;
        this.resetEvaluator();
        batches.runEvaluatorOnRange(this, r2, false);
        T sum2 = this.computeValue(this.sum);
        int count2 = this.nonNullGroupCount;
        this.resetEvaluator();
        this.sum = this.plus(this.minus(this.computeValue(this.previousSum), sum1), sum2);
        this.nonNullGroupCount = this.previousCount - count1 + count2;
        return this.divide(this.sum, this.nonNullGroupCount);
    }

    @Override
    public void onResultCalculated(Object result, Range range) {
        this.previousSum = this.computeValue(this.sum);
        this.previousCount = this.nonNullGroupCount;
        this.previousRange = range;
    }

    @Override
    public void onPartitionEnd() {
        this.previousSum = null;
        this.previousCount = 0;
        this.previousRange = null;
    }

    @Override
    public boolean streamsResult() {
        return false;
    }

    protected abstract T computeValue(T var1);

    protected abstract T plus(T var1, T var2);

    protected abstract T minus(T var1, T var2);

    protected abstract Object divide(T var1, long var2);

    @Override
    public boolean isGroupResultNull() {
        return this.isGroupResultNull;
    }
}

