/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast;

import java.io.IOException;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.persistence.MatchTracker;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastBytesHashMap;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastBytesHashMapStore;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastHashTableContainerBase;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastMultiKeyHashMap;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastNonMatchedIterator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinBytesHashMap;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashMapResult;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinNonMatchedIterator;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hive.common.util.HashCodeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorMapJoinFastMultiKeyHashMapContainer
extends VectorMapJoinFastHashTableContainerBase
implements VectorMapJoinBytesHashMap {
    private static final Logger LOG = LoggerFactory.getLogger(VectorMapJoinFastMultiKeyHashMapContainer.class);
    private final VectorMapJoinFastMultiKeyHashMap[] vectorMapJoinFastMultiKeyHashMaps;
    private final int numThreads;

    public VectorMapJoinFastMultiKeyHashMapContainer(boolean isFullOuter, int initialCapacity, float loadFactor, int writeBuffersSize, long estimatedKeyCount, int numHTs) {
        this.vectorMapJoinFastMultiKeyHashMaps = new VectorMapJoinFastMultiKeyHashMap[numHTs];
        LOG.info("Initializing {} HT Containers ", (Object)numHTs);
        for (int i = 0; i < numHTs; ++i) {
            this.vectorMapJoinFastMultiKeyHashMaps[i] = new VectorMapJoinFastMultiKeyHashMap(isFullOuter, initialCapacity, loadFactor, writeBuffersSize, estimatedKeyCount);
        }
        this.numThreads = numHTs;
    }

    @Override
    public long getHashCode(BytesWritable currentKey) throws HiveException, IOException {
        byte[] keyBytes = currentKey.getBytes();
        int keyLength = currentKey.getLength();
        return HashCodeUtil.murmurHash((byte[])keyBytes, (int)0, (int)keyLength);
    }

    @Override
    public void putRow(long hashCode, BytesWritable currentKey, BytesWritable currentValue) throws HiveException, IOException {
        this.vectorMapJoinFastMultiKeyHashMaps[(int)((long)(this.numThreads - 1) & hashCode)].putRow(hashCode, currentKey, currentValue);
    }

    @Override
    public long getEstimatedMemorySize() {
        long estimatedMemorySize = 0L;
        for (int i = 0; i < this.numThreads; ++i) {
            estimatedMemorySize += this.vectorMapJoinFastMultiKeyHashMaps[i].getEstimatedMemorySize();
        }
        return estimatedMemorySize;
    }

    @Override
    public int size() {
        int size = 0;
        for (int i = 0; i < this.numThreads; ++i) {
            size += this.vectorMapJoinFastMultiKeyHashMaps[i].size();
        }
        return size;
    }

    @Override
    public MatchTracker createMatchTracker() {
        MatchTracker parentMatchTracker = MatchTracker.createPartitioned(this.numThreads);
        for (int i = 0; i < this.numThreads; ++i) {
            int childSize = this.vectorMapJoinFastMultiKeyHashMaps[i].logicalHashBucketCount;
            parentMatchTracker.addPartition(i, childSize);
        }
        return parentMatchTracker;
    }

    @Override
    public VectorMapJoinNonMatchedIterator createNonMatchedIterator(MatchTracker matchTracker) {
        return new NonMatchedBytesHashMapParallelIterator(matchTracker, this.vectorMapJoinFastMultiKeyHashMaps, this.numThreads);
    }

    @Override
    public int spillPartitionId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public JoinUtil.JoinResult lookup(byte[] keyBytes, int keyStart, int keyLength, VectorMapJoinHashMapResult hashMapResult) throws IOException {
        long hashCode = HashCodeUtil.murmurHash((byte[])keyBytes, (int)keyStart, (int)keyLength);
        return this.vectorMapJoinFastMultiKeyHashMaps[(int)((long)(this.numThreads - 1) & hashCode)].lookup(keyBytes, keyStart, keyLength, hashMapResult);
    }

    @Override
    public JoinUtil.JoinResult lookup(byte[] keyBytes, int keyStart, int keyLength, VectorMapJoinHashMapResult hashMapResult, MatchTracker matchTracker) throws IOException {
        long hashCode = HashCodeUtil.murmurHash((byte[])keyBytes, (int)keyStart, (int)keyLength);
        int partition = (int)((long)(this.numThreads - 1) & hashCode);
        MatchTracker childMatchTracker = matchTracker != null ? matchTracker.getPartition(partition) : null;
        return this.vectorMapJoinFastMultiKeyHashMaps[partition].lookup(keyBytes, keyStart, keyLength, hashMapResult, childMatchTracker);
    }

    @Override
    public VectorMapJoinHashMapResult createHashMapResult() {
        return new VectorMapJoinFastBytesHashMapStore.HashMapResult();
    }

    public static class NonMatchedBytesHashMapParallelIterator
    extends VectorMapJoinFastNonMatchedIterator {
        private VectorMapJoinFastBytesHashMap.NonMatchedBytesHashMapIterator[] hashMapIterators;
        private int index;
        private int numThreads;

        NonMatchedBytesHashMapParallelIterator(MatchTracker matchTracker, VectorMapJoinFastBytesHashMap[] hashMaps, int numThreads) {
            super(matchTracker);
            this.hashMapIterators = new VectorMapJoinFastBytesHashMap.NonMatchedBytesHashMapIterator[numThreads];
            for (int i = 0; i < numThreads; ++i) {
                this.hashMapIterators[i] = new VectorMapJoinFastBytesHashMap.NonMatchedBytesHashMapIterator(matchTracker.getPartition(i), hashMaps[i]);
            }
            this.index = 0;
            this.numThreads = numThreads;
        }

        @Override
        public void init() {
            for (int i = 0; i < this.numThreads; ++i) {
                this.hashMapIterators[i].init();
            }
            this.index = 0;
        }

        @Override
        public boolean findNextNonMatched() {
            while (this.index < this.numThreads) {
                if (this.hashMapIterators[this.index].findNextNonMatched()) {
                    return true;
                }
                ++this.index;
            }
            return false;
        }

        @Override
        public boolean readNonMatchedBytesKey() throws HiveException {
            return this.hashMapIterators[this.index].readNonMatchedBytesKey();
        }

        @Override
        public byte[] getNonMatchedBytes() {
            return this.hashMapIterators[this.index].getNonMatchedBytes();
        }

        @Override
        public int getNonMatchedBytesOffset() {
            return this.hashMapIterators[this.index].getNonMatchedBytesOffset();
        }

        @Override
        public int getNonMatchedBytesLength() {
            return this.hashMapIterators[this.index].getNonMatchedBytesLength();
        }

        @Override
        public VectorMapJoinHashMapResult getNonMatchedHashMapResult() {
            return this.hashMapIterators[this.index].getNonMatchedHashMapResult();
        }
    }
}

