/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class StringColumnNotBetween
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private final byte[] left;
    private final byte[] right;

    public StringColumnNotBetween() {
        this.left = null;
        this.right = null;
    }

    public StringColumnNotBetween(int colNum, byte[] left, byte[] right, int outputColumnNum) {
        super(colNum, outputColumnNum);
        this.left = left;
        this.right = right;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        BytesColumnVector inputColVector = (BytesColumnVector)batch.cols[this.inputColumnNum[0]];
        LongColumnVector outputColVector = (LongColumnVector)batch.cols[this.outputColumnNum];
        int[] sel = batch.selected;
        boolean[] inputIsNull = inputColVector.isNull;
        int n = batch.size;
        byte[][] vector = inputColVector.vector;
        int[] start = inputColVector.start;
        int[] length = inputColVector.length;
        long[] outputVector = outputColVector.vector;
        boolean[] outputIsNull = outputColVector.isNull;
        if (n == 0) {
            return;
        }
        outputColVector.isRepeating = false;
        if (inputColVector.isRepeating) {
            if (inputColVector.noNulls || !inputIsNull[0]) {
                outputIsNull[0] = false;
                byte[] repeatBytes = vector[0];
                int repeatStart = start[0];
                int repeatLength = length[0];
                outputVector[0] = StringExpr.compare((byte[])repeatBytes, (int)repeatStart, (int)repeatLength, (byte[])this.left, (int)0, (int)this.left.length) >= 0 && StringExpr.compare((byte[])this.right, (int)0, (int)this.right.length, (byte[])repeatBytes, (int)repeatStart, (int)repeatLength) >= 0 ? 0L : 1L;
            } else {
                outputIsNull[0] = true;
                outputColVector.noNulls = false;
            }
            outputColVector.isRepeating = true;
            return;
        }
        if (inputColVector.noNulls) {
            if (batch.selectedInUse) {
                if (!outputColVector.noNulls) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputIsNull[i] = false;
                        byte[] valueBytes = vector[i];
                        int valueStart = start[i];
                        int valueLength = length[i];
                        outputVector[i] = StringExpr.compare((byte[])valueBytes, (int)valueStart, (int)valueLength, (byte[])this.left, (int)0, (int)this.left.length) >= 0 && StringExpr.compare((byte[])this.right, (int)0, (int)this.right.length, (byte[])valueBytes, (int)valueStart, (int)valueLength) >= 0 ? 0L : 1L;
                    }
                } else {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        byte[] valueBytes = vector[i];
                        int valueStart = start[i];
                        int valueLength = length[i];
                        outputVector[i] = StringExpr.compare((byte[])valueBytes, (int)valueStart, (int)valueLength, (byte[])this.left, (int)0, (int)this.left.length) >= 0 && StringExpr.compare((byte[])this.right, (int)0, (int)this.right.length, (byte[])valueBytes, (int)valueStart, (int)valueLength) >= 0 ? 0L : 1L;
                    }
                }
            } else {
                if (!outputColVector.noNulls) {
                    Arrays.fill(outputIsNull, false);
                    outputColVector.noNulls = true;
                }
                for (int i = 0; i != n; ++i) {
                    byte[] valueBytes = vector[i];
                    int valueStart = start[i];
                    int valueLength = length[i];
                    outputVector[i] = StringExpr.compare((byte[])valueBytes, (int)valueStart, (int)valueLength, (byte[])this.left, (int)0, (int)this.left.length) >= 0 && StringExpr.compare((byte[])this.right, (int)0, (int)this.right.length, (byte[])valueBytes, (int)valueStart, (int)valueLength) >= 0 ? 0L : 1L;
                }
            }
        } else {
            outputColVector.noNulls = false;
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputColVector.isNull[i] = inputIsNull[i];
                    if (inputIsNull[i]) continue;
                    byte[] valueBytes = vector[i];
                    int valueStart = start[i];
                    int valueLength = length[i];
                    outputVector[i] = StringExpr.compare((byte[])valueBytes, (int)valueStart, (int)valueLength, (byte[])this.left, (int)0, (int)this.left.length) >= 0 && StringExpr.compare((byte[])this.right, (int)0, (int)this.right.length, (byte[])valueBytes, (int)valueStart, (int)valueLength) >= 0 ? 0L : 1L;
                }
            } else {
                System.arraycopy(inputIsNull, 0, outputColVector.isNull, 0, n);
                for (int i = 0; i != n; ++i) {
                    if (inputIsNull[i]) continue;
                    byte[] valueBytes = vector[i];
                    int valueStart = start[i];
                    int valueLength = length[i];
                    outputVector[i] = StringExpr.compare((byte[])valueBytes, (int)valueStart, (int)valueLength, (byte[])this.left, (int)0, (int)this.left.length) >= 0 && StringExpr.compare((byte[])this.right, (int)0, (int)this.right.length, (byte[])valueBytes, (int)valueStart, (int)valueLength) >= 0 ? 0L : 1L;
                }
            }
        }
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return null;
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.inputColumnNum[0]) + ", left " + StringColumnNotBetween.displayUtf8Bytes(this.left) + ", right " + StringColumnNotBetween.displayUtf8Bytes(this.right);
    }
}

