/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.MapColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFMapIndexBaseScalar;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;

public class VectorUDFMapIndexDecimalScalar
extends VectorUDFMapIndexBaseScalar {
    private static final long serialVersionUID = 1L;
    private HiveDecimal key;
    private double doubleKey;

    public VectorUDFMapIndexDecimalScalar() {
    }

    public VectorUDFMapIndexDecimalScalar(int mapColumnNum, HiveDecimal key, int outputColumnNum) {
        super(mapColumnNum, outputColumnNum);
        this.key = key;
        this.doubleKey = key.doubleValue();
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.getMapColumnNum()) + ", key: " + this.key;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.MAP, VectorExpressionDescriptor.ArgumentType.DECIMAL).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR).build();
    }

    @Override
    public int findScalarInMap(MapColumnVector mapColumnVector, int mapBatchIndex) {
        int offset = (int)mapColumnVector.offsets[mapBatchIndex];
        int count = (int)mapColumnVector.lengths[mapBatchIndex];
        ColumnVector keys = mapColumnVector.keys;
        if (keys instanceof DecimalColumnVector) {
            HiveDecimalWritable[] decimalKeyVector = ((DecimalColumnVector)keys).vector;
            for (int i = 0; i < count; ++i) {
                if (decimalKeyVector[offset + i].compareTo(this.key) != 0) continue;
                return offset + i;
            }
        } else {
            double[] doubleKeyVector = ((DoubleColumnVector)keys).vector;
            for (int i = 0; i < count; ++i) {
                if (doubleKeyVector[offset + i] != this.doubleKey) continue;
                return offset + i;
            }
        }
        return -1;
    }
}

