/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.nio.charset.StandardCharsets;
import org.apache.hadoop.hive.common.format.datetime.HiveSqlDateTimeFormatter;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastDateToVarChar;

public class CastDateToVarCharWithFormat
extends CastDateToVarChar {
    private static final long serialVersionUID = 1L;
    private HiveSqlDateTimeFormatter sqlFormatter;

    public CastDateToVarCharWithFormat() {
    }

    public CastDateToVarCharWithFormat(int inputColumn, byte[] patternBytes, int len, int outputColumnNum) {
        super(inputColumn, outputColumnNum);
        if (patternBytes == null) {
            throw new IllegalStateException("Tried to cast (<date> to varchar with format <pattern>), but <pattern> not found");
        }
        this.sqlFormatter = new HiveSqlDateTimeFormatter(new String(patternBytes, StandardCharsets.UTF_8), false);
    }

    @Override
    protected void func(BytesColumnVector outV, long[] vector, int i) {
        super.sqlFormat(outV, vector, i, this.sqlFormatter);
    }

    @Override
    public String vectorExpressionParameters() {
        return super.vectorExpressionParameters() + ", format pattern: " + this.sqlFormatter.getPattern();
    }
}

