/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.io.HiveKey;
import org.apache.hadoop.io.serializer.JavaSerialization;
import org.apache.hadoop.io.serializer.WritableSerialization;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Partitioner;
import org.apache.hadoop.mapred.lib.TotalOrderPartitioner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TezTotalOrderPartitioner
implements Partitioner<HiveKey, Object>,
Configurable {
    private static final Logger LOG = LoggerFactory.getLogger(TezTotalOrderPartitioner.class);
    private Partitioner<HiveKey, Object> partitioner;
    private static final String TEZ_RUNTIME_FRAMEWORK_PREFIX = "tez.runtime.framework.";
    public static final String TEZ_RUNTIME_NUM_EXPECTED_PARTITIONS = "tez.runtime.framework.num.expected.partitions";

    public void configure(JobConf job) {
        if (this.partitioner == null) {
            this.configurePartitioner(new JobConf((Configuration)job));
        }
    }

    public void setConf(Configuration conf) {
        if (this.partitioner == null) {
            this.configurePartitioner(new JobConf(conf));
        }
    }

    public int getPartition(HiveKey key, Object value, int numPartitions) {
        return this.partitioner.getPartition((Object)key, value, numPartitions);
    }

    public Configuration getConf() {
        return null;
    }

    private void configurePartitioner(JobConf conf) {
        LOG.info(TotalOrderPartitioner.getPartitionFile((JobConf)conf));
        conf.setMapOutputKeyClass(HiveKey.class);
        LOG.info(conf.get("io.serializations"));
        conf.setStrings("io.serializations", new String[]{JavaSerialization.class.getName(), WritableSerialization.class.getName()});
        int partitions = conf.getInt(TEZ_RUNTIME_NUM_EXPECTED_PARTITIONS, -1);
        conf.setInt("mapreduce.job.reduces", partitions);
        this.partitioner = new TotalOrderPartitioner();
        this.partitioner.configure(conf);
    }
}

