/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.tez.AvailableSlotsCalculator;
import org.apache.hadoop.hive.ql.exec.tez.HiveSplitGenerator;
import org.apache.tez.runtime.api.InputInitializerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TezAvailableSlotsCalculator
implements AvailableSlotsCalculator {
    private static final Logger LOG = LoggerFactory.getLogger(TezAvailableSlotsCalculator.class);
    private InputInitializerContext inputInitializerContext;

    @Override
    public void initialize(Configuration conf, HiveSplitGenerator splitGenerator) {
        this.inputInitializerContext = splitGenerator.getContext();
    }

    @Override
    public int getAvailableSlots() {
        if (this.inputInitializerContext == null) {
            return 1;
        }
        int totalResource = this.inputInitializerContext.getTotalAvailableResource().getMemory();
        int taskResource = this.inputInitializerContext.getVertexTaskResource().getMemory();
        int availableSlots = totalResource / taskResource;
        LOG.debug("totalResource: {}mb / taskResource: {}mb =  availableSlots: {}", new Object[]{totalResource, taskResource, availableSlots});
        return availableSlots;
    }
}

