/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.workloadmanagement.resourceplan.show.formatter;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.hadoop.hive.metastore.api.WMFullResourcePlan;
import org.apache.hadoop.hive.metastore.api.WMResourcePlan;
import org.apache.hadoop.hive.ql.ddl.workloadmanagement.resourceplan.show.formatter.ShowResourcePlanFormatter;
import org.apache.hadoop.hive.ql.metadata.HiveException;

class TextShowResourcePlanFormatter
extends ShowResourcePlanFormatter {
    TextShowResourcePlanFormatter() {
    }

    @Override
    public void showResourcePlans(DataOutputStream out, List<WMResourcePlan> resourcePlans) throws HiveException {
        try {
            for (WMResourcePlan plan : resourcePlans) {
                out.write(plan.getName().getBytes(StandardCharsets.UTF_8));
                out.write(9);
                out.write(plan.getStatus().name().getBytes(StandardCharsets.UTF_8));
                out.write(9);
                String queryParallelism = plan.isSetQueryParallelism() ? Integer.toString(plan.getQueryParallelism()) : "null";
                out.write(queryParallelism.getBytes(StandardCharsets.UTF_8));
                out.write(9);
                String defaultPoolPath = plan.isSetDefaultPoolPath() ? plan.getDefaultPoolPath() : "null";
                out.write(defaultPoolPath.getBytes(StandardCharsets.UTF_8));
                out.write(10);
            }
        }
        catch (IOException e) {
            throw new HiveException((Throwable)e);
        }
    }

    @Override
    public void showFullResourcePlan(DataOutputStream out, WMFullResourcePlan resourcePlan) throws HiveException {
        TextShowResourcePlanFormatter.formatFullRP(new TextRPFormatter(out), resourcePlan);
    }

    private static class TextRPFormatter
    implements ShowResourcePlanFormatter.RPFormatter {
        private static final byte[] INDENT = "    ".getBytes(StandardCharsets.UTF_8);
        private static final byte[] INDENT2 = " |  ".getBytes(StandardCharsets.UTF_8);
        private static final byte[] INDENT_BRANCH = " +  ".getBytes(StandardCharsets.UTF_8);
        private final DataOutputStream out;
        private int indentLevel = 0;

        TextRPFormatter(DataOutputStream out) {
            this.out = out;
        }

        @Override
        public void startRP(String rpName, Object ... keyValuePairs) throws IOException {
            this.out.write(rpName.getBytes(StandardCharsets.UTF_8));
            this.writeFields(keyValuePairs);
            this.out.write(10);
        }

        @Override
        public void endRP() throws IOException {
        }

        @Override
        public void startPools() throws IOException {
        }

        @Override
        public void endPools() throws IOException {
        }

        @Override
        public void startPool(String poolName, Object ... keyValuePairs) throws IOException {
            ++this.indentLevel;
            this.writeIndent(true);
            this.out.write(poolName.getBytes(StandardCharsets.UTF_8));
            this.writeFields(keyValuePairs);
            this.out.write(10);
        }

        @Override
        public void endPool() throws IOException {
            --this.indentLevel;
        }

        @Override
        public void startTriggers() throws IOException {
        }

        @Override
        public void startMappings() throws IOException {
        }

        @Override
        public void endTriggers() throws IOException {
        }

        @Override
        public void endMappings() throws IOException {
        }

        private void writeFields(Object ... keyValuePairs) throws IOException {
            if (keyValuePairs.length % 2 != 0) {
                throw new IllegalArgumentException("Expected pairs, got: " + keyValuePairs.length);
            }
            if (keyValuePairs.length < 2) {
                return;
            }
            this.out.write(91);
            this.out.write(this.getKeyValueText(0, keyValuePairs).getBytes(StandardCharsets.UTF_8));
            for (int i = 2; i < keyValuePairs.length; i += 2) {
                this.out.write(44);
                this.out.write(this.getKeyValueText(i, keyValuePairs).getBytes(StandardCharsets.UTF_8));
            }
            this.out.write(93);
        }

        private String getKeyValueText(int i, Object ... keyValuePairs) {
            return String.format("%s=%s", keyValuePairs[i], keyValuePairs[i + 1] == null ? "null" : keyValuePairs[i + 1]);
        }

        @Override
        public void formatTrigger(String triggerName, String actionExpression, String triggerExpression) throws IOException {
            this.writeIndent(false);
            String triggerText = String.format("trigger %s: if (%s) { %s }", triggerName, triggerExpression, actionExpression);
            this.out.write(triggerText.getBytes(StandardCharsets.UTF_8));
            this.out.write(10);
        }

        @Override
        public void formatMappingType(String type, List<String> names) throws IOException {
            this.writeIndent(false);
            this.out.write(("mapped for " + type.toLowerCase()).getBytes(StandardCharsets.UTF_8));
            if (!names.isEmpty()) {
                this.out.write("s: ".getBytes(StandardCharsets.UTF_8));
                int count = Math.min(5, names.size());
                for (int i = 0; i < count; ++i) {
                    if (i != 0) {
                        this.out.write(", ".getBytes(StandardCharsets.UTF_8));
                    }
                    this.out.write(names.get(i).getBytes(StandardCharsets.UTF_8));
                }
                int remaining = names.size() - count;
                if (remaining > 0) {
                    this.out.write((" and " + remaining + " others").getBytes(StandardCharsets.UTF_8));
                }
            }
            this.out.write(10);
        }

        private void writeIndent(boolean isPool) throws IOException {
            for (int i = 0; i < this.indentLevel - 1; ++i) {
                this.out.write(INDENT);
            }
            if (isPool) {
                this.out.write(INDENT_BRANCH);
            } else {
                this.out.write(INDENT);
                this.out.write(INDENT2);
            }
        }
    }
}

