/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.info.show.properties;

import java.io.Serializable;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.ql.ddl.DDLDesc;
import org.apache.hadoop.hive.ql.plan.Explain;

@Explain(displayName="Show Table Properties", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class ShowTablePropertiesDesc
implements DDLDesc,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SCHEMA = "prpt_name,prpt_value#string:string";
    private final String resFile;
    private final TableName tableName;
    private final String propertyName;

    public ShowTablePropertiesDesc(String resFile, TableName tableName, String propertyName) {
        this.resFile = resFile;
        this.tableName = tableName;
        this.propertyName = propertyName;
    }

    public String getResFile() {
        return this.resFile;
    }

    @Explain(displayName="result file", explainLevels={Explain.Level.EXTENDED})
    public String getResFileString() {
        return this.getResFile();
    }

    @Explain(displayName="table name", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getTableName() {
        return this.tableName.getNotEmptyDbTable();
    }

    @Explain(displayName="property name")
    public String getPropertyName() {
        return this.propertyName;
    }
}

