/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.database.create;

import java.util.Map;
import org.apache.hadoop.hive.metastore.api.DataConnector;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.DatabaseType;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.database.create.CreateDatabaseDesc;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.session.SessionState;

@DDLSemanticAnalyzerFactory.DDLType(types={949})
public class CreateDatabaseAnalyzer
extends BaseSemanticAnalyzer {
    public CreateDatabaseAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode root) throws SemanticException {
        String databaseName = CreateDatabaseAnalyzer.unescapeIdentifier(root.getChild(0).getText());
        boolean ifNotExists = false;
        String comment = null;
        String locationUri = null;
        String managedLocationUri = null;
        String type = DatabaseType.NATIVE.name();
        String connectorName = null;
        Map<String, String> props = null;
        block8: for (int i = 1; i < root.getChildCount(); ++i) {
            ASTNode childNode = (ASTNode)root.getChild(i);
            switch (childNode.getToken().getType()) {
                case 1051: {
                    ifNotExists = true;
                    continue block8;
                }
                case 966: {
                    comment = CreateDatabaseAnalyzer.unescapeSQLString(childNode.getChild(0).getText());
                    continue block8;
                }
                case 968: {
                    props = CreateDatabaseAnalyzer.getProps((ASTNode)childNode.getChild(0));
                    continue block8;
                }
                case 967: {
                    locationUri = CreateDatabaseAnalyzer.unescapeSQLString(childNode.getChild(0).getText());
                    this.outputs.add(this.toWriteEntity(locationUri));
                    continue block8;
                }
                case 969: {
                    managedLocationUri = CreateDatabaseAnalyzer.unescapeSQLString(childNode.getChild(0).getText());
                    this.outputs.add(this.toWriteEntity(managedLocationUri));
                    continue block8;
                }
                case 970: {
                    type = DatabaseType.REMOTE.name();
                    ASTNode nextNode = (ASTNode)root.getChild(i);
                    connectorName = nextNode.getChild(0).getText();
                    DataConnector connector = this.getDataConnector(connectorName, true);
                    if (connector == null) {
                        throw new SemanticException("Cannot retrieve connector with name: " + connectorName);
                    }
                    this.inputs.add(new ReadEntity(connector));
                    continue block8;
                }
                default: {
                    throw new SemanticException("Unrecognized token in CREATE DATABASE statement");
                }
            }
        }
        if (ifNotExists && this.getDatabase(databaseName, false) != null) {
            return;
        }
        CreateDatabaseDesc desc = null;
        Database database = new Database(databaseName, comment, locationUri, props);
        if (type.equalsIgnoreCase(DatabaseType.NATIVE.name())) {
            desc = new CreateDatabaseDesc(databaseName, comment, locationUri, managedLocationUri, ifNotExists, props);
            database.setType(DatabaseType.NATIVE);
            if (managedLocationUri != null) {
                database.setManagedLocationUri(managedLocationUri);
            }
        } else {
            String remoteDbName = databaseName;
            if (props != null && props.get("connector.remoteDbName") != null) {
                remoteDbName = props.get("connector.remoteDbName");
            }
            desc = new CreateDatabaseDesc(databaseName, comment, locationUri, null, ifNotExists, props, type, connectorName, remoteDbName);
            database.setConnector_name(connectorName);
            database.setType(DatabaseType.REMOTE);
            database.setRemote_dbname(remoteDbName);
        }
        database.setOwnerName(SessionState.getUserFromAuthenticator());
        database.setOwnerType(PrincipalType.USER);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
        this.outputs.add(new WriteEntity(database, WriteEntity.WriteType.DDL_NO_LOCK));
    }
}

